DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'IS_VISIBLE';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` ADD COLUMN `IS_VISIBLE` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.INDICATOR SET IS_VISIBLE = 1 WHERE IS_VISIBLE IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'IS_VISIBLE'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` CHANGE COLUMN `IS_VISIBLE` `IS_VISIBLE` TINYINT(1) NOT NULL COMMENT 'If the indicator is visible.';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'CHART_MODE';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` ADD COLUMN `CHART_MODE` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.INDICATOR SET CHART_MODE = 1 WHERE CHART_MODE IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'CHART_MODE'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` CHANGE COLUMN `CHART_MODE` `CHART_MODE` TINYINT(1) NOT NULL COMMENT 'If the indicator is a chart.';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'GROUP_POSITION';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` ADD COLUMN `GROUP_POSITION` TINYINT(3) COMMENT 'The group position';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'POSITION';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` ADD COLUMN `POSITION` TINYINT(3) COMMENT 'The indicator position within the group';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'INDICATOR' 
  AND COLUMN_NAME = 'GRID_COLUMNS';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`INDICATOR` ADD COLUMN `GRID_COLUMNS` TEXT COMMENT 'The grid columns configuration.';
    END IF;
END
$$

CALL createColumn();
$$
