DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'AREA'
    AND    COLUMN_NAME = 'IS_VISIBLE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.AREA ADD IS_VISIBLE NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.AREA.IS_VISIBLE IS 'If the area is visible.';

UPDATE DIF.AREA SET IS_VISIBLE = 1 WHERE IS_VISIBLE IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'AREA'
  AND    COLUMN_NAME = 'IS_VISIBLE'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AREA MODIFY IS_VISIBLE NOT NULL';
  END IF;
END;
/
