/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IServerDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class ServerDAOImpl
implements IServerDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Server> getServerDataSet() {
        return new HibernateDataSet(Server.class, (IHibernateDAO)this, Server.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Server transientInstance) {
        this.logger.debug((Object)"persisting Server instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Server instance) {
        this.logger.debug((Object)"attaching dirty Server instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Server instance) {
        this.logger.debug((Object)"attaching clean Server instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Server persistentInstance) {
        this.logger.debug((Object)"deleting Server instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Server merge(Server detachedInstance) {
        this.logger.debug((Object)"merging Server instance");
        Server result = (Server)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Server findById(Long id) {
        this.logger.debug((Object)("getting Server instance with id: " + id));
        Server instance = (Server)this.getSession().get(Server.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Server> findAll() {
        List<Server> instances = new ArrayList();
        this.logger.debug((Object)"getting all Server instances");
        instances = this.getSession().createCriteria(Server.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Server> findByExample(Server instance) {
        this.logger.debug((Object)"finding Server instance by example");
        List results = this.getSession().createCriteria(Server.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Server> findByFieldParcial(Server.Fields field, String value) {
        this.logger.debug((Object)("finding Server instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Server.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

