/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.ecommerce;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.ecommerce.ECommerceBusinessDefinition;
import pt.digitalis.dif.ecommerce.IECommerce;
import pt.digitalis.dif.ecommerce.IECommerceBusiness;
import pt.digitalis.dif.ecommerce.PaymentRequest;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.ioc.modules.IoCBinder;

public abstract class AbstractECommerceBusinessImpl
implements IECommerceBusiness {
    private static String fullIdentifier = null;
    private static String shortIdentifier = null;

    public static void bindIoC(IoCBinder binder, Class<? extends AbstractECommerceBusinessImpl> businessImplClass) {
        binder.bind(IECommerceBusiness.class, businessImplClass).withId(businessImplClass.getAnnotation(ECommerceBusinessDefinition.class).fullId());
    }

    public static <T extends AbstractECommerceBusinessImpl> T getInstance(Class<T> clazz) {
        return (T)((AbstractECommerceBusinessImpl)DIFIoCRegistry.getRegistry().getImplementation(IECommerceBusiness.class, clazz.getAnnotation(ECommerceBusinessDefinition.class).fullId()));
    }

    @Override
    public String decode(EcommercePayments paymentRecord) {
        return paymentRecord.getBusinessId().split("-")[1];
    }

    @Override
    public String encodeBusinessId(String businessID, IECommerce<?> eCommerceImplementation) {
        return this.encodeBusinessId(businessID, eCommerceImplementation.getShortIdentifier());
    }

    @Override
    public String encodeBusinessId(String businessID, String eCommerceImplementationID) {
        return eCommerceImplementationID + ":" + this.getShortIdentifier() + "-" + businessID;
    }

    @Override
    public String getFullIdentifier() {
        if (fullIdentifier == null) {
            this.initializeIdentifiersFromAnnotation();
        }
        return fullIdentifier;
    }

    @Override
    public String getShortIdentifier() {
        if (shortIdentifier == null) {
            this.initializeIdentifiersFromAnnotation();
        }
        return shortIdentifier;
    }

    private void initializeIdentifiersFromAnnotation() {
        ECommerceBusinessDefinition def = this.getClass().getAnnotation(ECommerceBusinessDefinition.class);
        shortIdentifier = def.shortId();
        fullIdentifier = def.fullId();
    }

    @Override
    public PaymentRequest newPaymentRequest(IDIFContext context) {
        PaymentRequest paymentRequest = new PaymentRequest(context);
        paymentRequest.setCreator(this.getFullIdentifier());
        return paymentRequest;
    }
}

