/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl;

import org.hibernate.cfg.Configuration;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractModelManager;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;

import java.util.Properties;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Dec 19, 2013
 */
public class DIFRepositoryDBModelManager extends AbstractModelManager
{

    /** the model identifier */
    public static String MODEL_ID = "DIF";

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#allowUseCustomDatabaseConfigurations()
     */
    @Override
    protected boolean allowUseCustomDatabaseConfigurations()
    {
        return false;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getConfiguration()
     */
    @Override
    public Configuration getConfiguration() throws ConfigurationException
    {
        Properties dbProps = null;

        if (DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class).getClass()
                .equals(DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class, "Database").getClass()))
        {
            dbProps = DIFStartupConfiguration.getDbProps();

            // if no properties exist in dif configuration file, set an empty one to be read instead of the defult
            // configuration based database properties
            if (dbProps == null)
                dbProps = new Properties();
        }

        return HibernateUtil.getDatabaseConfiguration(DIFRepositoryFactory.SESSION_FACTORY_NAME, null, dbProps);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getDeclareJavaLocation()
     */
    @Override
    public Boolean getDeclareJavaLocation()
    {
        return true;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getFactoryName()
     */
    @Override
    public String getFactoryName()
    {
        return DIFRepositoryFactory.SESSION_FACTORY_NAME;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IModelManager#getSchema()
     */
    public String getSchema()
    {
        return "DIF";
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#readConfigurations()
     */
    @Override
    protected Properties readConfigurations()
    {
        return DIFStartupConfiguration.getDbProps();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#writeConfigurations(java.util.Properties)
     */
    @Override
    protected void writeConfigurations(Properties configsToSave)
    {
        DIFStartupConfiguration.setDbProps(configsToSave);
        DIFStartupConfiguration.updateConfig();
    }
}
