package pt.digitalis.dif.dem.managers.impl.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigurationDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Configuration;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigNodeDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigServerSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IConfigurationsService {

	/**
	 * Obtains a new Configuration DAO
	 *
	 * @return A new IConfigurationDAO
	 */
    public IConfigurationDAO getConfigurationDAO();

    /**
     * Obtains a new DataSet for the Configuration entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Configuration> getConfigurationDataSet();

	/**
	 * Obtains a new ConfigNode DAO
	 *
	 * @return A new IConfigNodeDAO
	 */
    public IConfigNodeDAO getConfigNodeDAO();

    /**
     * Obtains a new DataSet for the ConfigNode entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigNode> getConfigNodeDataSet();

	/**
	 * Obtains a new ConfigSet DAO
	 *
	 * @return A new IConfigSetDAO
	 */
    public IConfigSetDAO getConfigSetDAO();

    /**
     * Obtains a new DataSet for the ConfigSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigSet> getConfigSetDataSet();

	/**
	 * Obtains a new ConfigServerSet DAO
	 *
	 * @return A new IConfigServerSetDAO
	 */
    public IConfigServerSetDAO getConfigServerSetDAO();

    /**
     * Obtains a new DataSet for the ConfigServerSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigServerSet> getConfigServerSetDataSet();


    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}