package pt.digitalis.dif.dem.managers.impl.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventSubscriptionDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventLogProcessDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.EventLogProcess;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IEventsService {

	/**
	 * Obtains a new Event DAO
	 *
	 * @return A new IEventDAO
	 */
    public IEventDAO getEventDAO();

    /**
     * Obtains a new DataSet for the Event entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Event> getEventDataSet();

	/**
	 * Obtains a new EventSubscription DAO
	 *
	 * @return A new IEventSubscriptionDAO
	 */
    public IEventSubscriptionDAO getEventSubscriptionDAO();

    /**
     * Obtains a new DataSet for the EventSubscription entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventSubscription> getEventSubscriptionDataSet();

	/**
	 * Obtains a new EventLogProcess DAO
	 *
	 * @return A new IEventLogProcessDAO
	 */
    public IEventLogProcessDAO getEventLogProcessDAO();

    /**
     * Obtains a new DataSet for the EventLogProcess entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventLogProcess> getEventLogProcessDataSet();


    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}