package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ConfigNode.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IConfigNodeDAO extends IHibernateDAO<ConfigNode> {

    /**
     * Obtains a new DataSet for the ConfigNode entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigNode> getConfigNodeDataSet();

	/**
	 * Persist a ConfigNode object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ConfigNode transientInstance);

	/**
	 * Updates a modified ConfigNode in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ConfigNode instance);

	/**
	 * Attach an unmodified ConfigNode instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ConfigNode instance);

	/**
	 * Removes a ConfigNode instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ConfigNode persistentInstance);

	/**
	 * Merge a ConfigNode instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ConfigNode merge(ConfigNode detachedInstance);

	/**
	 * Finds a ConfigNode instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ConfigNode findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ConfigNode> findAll();


	/**
	 * Gets a {@link List} of all ConfigNode instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ConfigNode> findByFieldParcial(ConfigNode.Fields field, String value);

}
