package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Filter.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Filter
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IFilterDAO extends IHibernateDAO<Filter> {

    /**
     * Obtains a new DataSet for the Filter entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Filter> getFilterDataSet();

	/**
	 * Persist a Filter object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Filter transientInstance);

	/**
	 * Updates a modified Filter in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Filter instance);

	/**
	 * Attach an unmodified Filter instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Filter instance);

	/**
	 * Removes a Filter instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Filter persistentInstance);

	/**
	 * Merge a Filter instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Filter merge(Filter detachedInstance);

	/**
	 * Finds a Filter instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Filter findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Filter> findAll();


	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByFieldParcial(Filter.Fields field, String value);

}
