package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Indicator.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Indicator
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IIndicatorDAO extends IHibernateDAO<Indicator> {

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet();

	/**
	 * Persist a Indicator object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Indicator transientInstance);

	/**
	 * Updates a modified Indicator in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Indicator instance);

	/**
	 * Attach an unmodified Indicator instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Indicator instance);

	/**
	 * Removes a Indicator instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Indicator persistentInstance);

	/**
	 * Merge a Indicator instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Indicator merge(Indicator detachedInstance);

	/**
	 * Finds a Indicator instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Indicator findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findAll();


	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value);

}
