package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Serie;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Serie.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Serie
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface ISerieDAO extends IHibernateDAO<Serie> {

    /**
     * Obtains a new DataSet for the Serie entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Serie> getSerieDataSet();

	/**
	 * Persist a Serie object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Serie transientInstance);

	/**
	 * Updates a modified Serie in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Serie instance);

	/**
	 * Attach an unmodified Serie instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Serie instance);

	/**
	 * Removes a Serie instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Serie persistentInstance);

	/**
	 * Merge a Serie instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Serie merge(Serie detachedInstance);

	/**
	 * Finds a Serie instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Serie findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Serie> findAll();


	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Serie> findByFieldParcial(Serie.Fields field, String value);

}
