package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAccessLogDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class AccessLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.AccessLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class AccessLogDAOImpl implements IAccessLogDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the AccessLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AccessLog> getAccessLogDataSet()
    {
        return new HibernateDataSet<AccessLog>(AccessLog.class, this, AccessLog.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AccessLogDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a AccessLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(AccessLog transientInstance) {
        logger.debug("persisting AccessLog instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified AccessLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(AccessLog instance) {
        logger.debug("attaching dirty AccessLog instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified AccessLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(AccessLog instance) {
        logger.debug("attaching clean AccessLog instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a AccessLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(AccessLog persistentInstance) {
        logger.debug("deleting AccessLog instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a AccessLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public AccessLog merge(AccessLog detachedInstance) {
        logger.debug("merging AccessLog instance");
        AccessLog result = (AccessLog) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a AccessLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public AccessLog findById( java.lang.Long id) {
        logger.debug("getting AccessLog instance with id: " + id);
        AccessLog instance = (AccessLog) getSession()
                .get(AccessLog.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<AccessLog> findAll() {

 		List<AccessLog> instances = new ArrayList<AccessLog>();
		logger.debug("getting all AccessLog instances");
        instances = getSession().createCriteria(AccessLog.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<AccessLog>) instances;
    }


	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<AccessLog> findByExample(AccessLog instance) {
        logger.debug("finding AccessLog instance by example");
        List<AccessLog> results = (List<AccessLog>) getSession()
                .createCriteria(AccessLog.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all AccessLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<AccessLog> findByFieldParcial(AccessLog.Fields field, String value) {
        logger.debug("finding AccessLog instance by parcial value: "+field+" like "+value);
        List<AccessLog> results = (List<AccessLog>) getSession()
                .createCriteria(AccessLog.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

