package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAclDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Acl.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Acl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class AclDAOImpl implements IAclDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Acl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Acl> getAclDataSet()
    {
        return new HibernateDataSet<Acl>(Acl.class, this, Acl.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AclDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Acl object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Acl transientInstance) {
        logger.debug("persisting Acl instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Acl in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Acl instance) {
        logger.debug("attaching dirty Acl instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Acl instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Acl instance) {
        logger.debug("attaching clean Acl instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Acl instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Acl persistentInstance) {
        logger.debug("deleting Acl instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Acl instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Acl merge(Acl detachedInstance) {
        logger.debug("merging Acl instance");
        Acl result = (Acl) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Acl instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Acl findById( java.lang.Long id) {
        logger.debug("getting Acl instance with id: " + id);
        Acl instance = (Acl) getSession()
                .get(Acl.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Acl instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Acl> findAll() {

 		List<Acl> instances = new ArrayList<Acl>();
		logger.debug("getting all Acl instances");
        instances = getSession().createCriteria(Acl.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Acl>) instances;
    }


	/**
	 * Gets a {@link List} of all Acl instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Acl> findByExample(Acl instance) {
        logger.debug("finding Acl instance by example");
        List<Acl> results = (List<Acl>) getSession()
                .createCriteria(Acl.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Acl instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Acl> findByFieldParcial(Acl.Fields field, String value) {
        logger.debug("finding Acl instance by parcial value: "+field+" like "+value);
        List<Acl> results = (List<Acl>) getSession()
                .createCriteria(Acl.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

