package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAreaDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Area.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Area
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class AreaDAOImpl implements IAreaDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Area entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Area> getAreaDataSet()
    {
        return new HibernateDataSet<Area>(Area.class, this, Area.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AreaDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Area object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Area transientInstance) {
        logger.debug("persisting Area instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Area in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Area instance) {
        logger.debug("attaching dirty Area instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Area instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Area instance) {
        logger.debug("attaching clean Area instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Area instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Area persistentInstance) {
        logger.debug("deleting Area instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Area instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Area merge(Area detachedInstance) {
        logger.debug("merging Area instance");
        Area result = (Area) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Area instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Area findById( java.lang.Long id) {
        logger.debug("getting Area instance with id: " + id);
        Area instance = (Area) getSession()
                .get(Area.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Area> findAll() {

 		List<Area> instances = new ArrayList<Area>();
		logger.debug("getting all Area instances");
        instances = getSession().createCriteria(Area.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Area>) instances;
    }


	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Area> findByExample(Area instance) {
        logger.debug("finding Area instance by example");
        List<Area> results = (List<Area>) getSession()
                .createCriteria(Area.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Area> findByFieldParcial(Area.Fields field, String value) {
        logger.debug("finding Area instance by parcial value: "+field+" like "+value);
        List<Area> results = (List<Area>) getSession()
                .createCriteria(Area.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

