package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigServerSetDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ConfigServerSet.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ConfigServerSetDAOImpl implements IConfigServerSetDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ConfigServerSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigServerSet> getConfigServerSetDataSet()
    {
        return new HibernateDataSet<ConfigServerSet>(ConfigServerSet.class, this, ConfigServerSet.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ConfigServerSetDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ConfigServerSet object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ConfigServerSet transientInstance) {
        logger.debug("persisting ConfigServerSet instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ConfigServerSet in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ConfigServerSet instance) {
        logger.debug("attaching dirty ConfigServerSet instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ConfigServerSet instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ConfigServerSet instance) {
        logger.debug("attaching clean ConfigServerSet instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ConfigServerSet instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ConfigServerSet persistentInstance) {
        logger.debug("deleting ConfigServerSet instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ConfigServerSet instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ConfigServerSet merge(ConfigServerSet detachedInstance) {
        logger.debug("merging ConfigServerSet instance");
        ConfigServerSet result = (ConfigServerSet) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ConfigServerSet instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ConfigServerSet findById( java.lang.Long id) {
        logger.debug("getting ConfigServerSet instance with id: " + id);
        ConfigServerSet instance = (ConfigServerSet) getSession()
                .get(ConfigServerSet.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ConfigServerSet instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigServerSet> findAll() {

 		List<ConfigServerSet> instances = new ArrayList<ConfigServerSet>();
		logger.debug("getting all ConfigServerSet instances");
        instances = getSession().createCriteria(ConfigServerSet.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ConfigServerSet>) instances;
    }


	/**
	 * Gets a {@link List} of all ConfigServerSet instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ConfigServerSet> findByExample(ConfigServerSet instance) {
        logger.debug("finding ConfigServerSet instance by example");
        List<ConfigServerSet> results = (List<ConfigServerSet>) getSession()
                .createCriteria(ConfigServerSet.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ConfigServerSet instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigServerSet> findByFieldParcial(ConfigServerSet.Fields field, String value) {
        logger.debug("finding ConfigServerSet instance by parcial value: "+field+" like "+value);
        List<ConfigServerSet> results = (List<ConfigServerSet>) getSession()
                .createCriteria(ConfigServerSet.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

