package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigSetDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ConfigSet.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ConfigSetDAOImpl implements IConfigSetDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ConfigSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigSet> getConfigSetDataSet()
    {
        return new HibernateDataSet<ConfigSet>(ConfigSet.class, this, ConfigSet.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ConfigSetDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ConfigSet object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ConfigSet transientInstance) {
        logger.debug("persisting ConfigSet instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ConfigSet in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ConfigSet instance) {
        logger.debug("attaching dirty ConfigSet instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ConfigSet instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ConfigSet instance) {
        logger.debug("attaching clean ConfigSet instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ConfigSet instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ConfigSet persistentInstance) {
        logger.debug("deleting ConfigSet instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ConfigSet instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ConfigSet merge(ConfigSet detachedInstance) {
        logger.debug("merging ConfigSet instance");
        ConfigSet result = (ConfigSet) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ConfigSet instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ConfigSet findById( java.lang.Long id) {
        logger.debug("getting ConfigSet instance with id: " + id);
        ConfigSet instance = (ConfigSet) getSession()
                .get(ConfigSet.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigSet> findAll() {

 		List<ConfigSet> instances = new ArrayList<ConfigSet>();
		logger.debug("getting all ConfigSet instances");
        instances = getSession().createCriteria(ConfigSet.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ConfigSet>) instances;
    }


	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ConfigSet> findByExample(ConfigSet instance) {
        logger.debug("finding ConfigSet instance by example");
        List<ConfigSet> results = (List<ConfigSet>) getSession()
                .createCriteria(ConfigSet.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ConfigSet instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ConfigSet> findByFieldParcial(ConfigSet.Fields field, String value) {
        logger.debug("finding ConfigSet instance by parcial value: "+field+" like "+value);
        List<ConfigSet> results = (List<ConfigSet>) getSession()
                .createCriteria(ConfigSet.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

