package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.DashboardIndicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IDashboardIndicatorDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class DashboardIndicator.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DashboardIndicator
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class DashboardIndicatorDAOImpl implements IDashboardIndicatorDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the DashboardIndicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DashboardIndicator> getDashboardIndicatorDataSet()
    {
        return new HibernateDataSet<DashboardIndicator>(DashboardIndicator.class, this, DashboardIndicator.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public DashboardIndicatorDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a DashboardIndicator object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DashboardIndicator transientInstance) {
        logger.debug("persisting DashboardIndicator instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified DashboardIndicator in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DashboardIndicator instance) {
        logger.debug("attaching dirty DashboardIndicator instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified DashboardIndicator instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DashboardIndicator instance) {
        logger.debug("attaching clean DashboardIndicator instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a DashboardIndicator instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DashboardIndicator persistentInstance) {
        logger.debug("deleting DashboardIndicator instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a DashboardIndicator instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DashboardIndicator merge(DashboardIndicator detachedInstance) {
        logger.debug("merging DashboardIndicator instance");
        DashboardIndicator result = (DashboardIndicator) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a DashboardIndicator instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DashboardIndicator findById( java.lang.Long id) {
        logger.debug("getting DashboardIndicator instance with id: " + id);
        DashboardIndicator instance = (DashboardIndicator) getSession()
                .get(DashboardIndicator.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all DashboardIndicator instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DashboardIndicator> findAll() {

 		List<DashboardIndicator> instances = new ArrayList<DashboardIndicator>();
		logger.debug("getting all DashboardIndicator instances");
        instances = getSession().createCriteria(DashboardIndicator.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<DashboardIndicator>) instances;
    }


	/**
	 * Gets a {@link List} of all DashboardIndicator instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<DashboardIndicator> findByExample(DashboardIndicator instance) {
        logger.debug("finding DashboardIndicator instance by example");
        List<DashboardIndicator> results = (List<DashboardIndicator>) getSession()
                .createCriteria(DashboardIndicator.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all DashboardIndicator instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DashboardIndicator> findByFieldParcial(DashboardIndicator.Fields field, String value) {
        logger.debug("finding DashboardIndicator instance by parcial value: "+field+" like "+value);
        List<DashboardIndicator> results = (List<DashboardIndicator>) getSession()
                .createCriteria(DashboardIndicator.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

