package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsent;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IDataConsentDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class DataConsent.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsent
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class DataConsentDAOImpl implements IDataConsentDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the DataConsent entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsent> getDataConsentDataSet()
    {
        return new HibernateDataSet<DataConsent>(DataConsent.class, this, DataConsent.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public DataConsentDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a DataConsent object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsent transientInstance) {
        logger.debug("persisting DataConsent instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified DataConsent in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsent instance) {
        logger.debug("attaching dirty DataConsent instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified DataConsent instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsent instance) {
        logger.debug("attaching clean DataConsent instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a DataConsent instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsent persistentInstance) {
        logger.debug("deleting DataConsent instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a DataConsent instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsent merge(DataConsent detachedInstance) {
        logger.debug("merging DataConsent instance");
        DataConsent result = (DataConsent) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a DataConsent instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsent findById( java.lang.Long id) {
        logger.debug("getting DataConsent instance with id: " + id);
        DataConsent instance = (DataConsent) getSession()
                .get(DataConsent.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsent> findAll() {

 		List<DataConsent> instances = new ArrayList<DataConsent>();
		logger.debug("getting all DataConsent instances");
        instances = getSession().createCriteria(DataConsent.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<DataConsent>) instances;
    }


	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<DataConsent> findByExample(DataConsent instance) {
        logger.debug("finding DataConsent instance by example");
        List<DataConsent> results = (List<DataConsent>) getSession()
                .createCriteria(DataConsent.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsent> findByFieldParcial(DataConsent.Fields field, String value) {
        logger.debug("finding DataConsent instance by parcial value: "+field+" like "+value);
        List<DataConsent> results = (List<DataConsent>) getSession()
                .createCriteria(DataConsent.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

