package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IDataConsentUserDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class DataConsentUser.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class DataConsentUserDAOImpl implements IDataConsentUserDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the DataConsentUser entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentUser> getDataConsentUserDataSet()
    {
        return new HibernateDataSet<DataConsentUser>(DataConsentUser.class, this, DataConsentUser.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public DataConsentUserDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a DataConsentUser object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsentUser transientInstance) {
        logger.debug("persisting DataConsentUser instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified DataConsentUser in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsentUser instance) {
        logger.debug("attaching dirty DataConsentUser instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified DataConsentUser instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsentUser instance) {
        logger.debug("attaching clean DataConsentUser instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a DataConsentUser instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsentUser persistentInstance) {
        logger.debug("deleting DataConsentUser instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a DataConsentUser instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsentUser merge(DataConsentUser detachedInstance) {
        logger.debug("merging DataConsentUser instance");
        DataConsentUser result = (DataConsentUser) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a DataConsentUser instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsentUser findById( java.lang.Long id) {
        logger.debug("getting DataConsentUser instance with id: " + id);
        DataConsentUser instance = (DataConsentUser) getSession()
                .get(DataConsentUser.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentUser> findAll() {

 		List<DataConsentUser> instances = new ArrayList<DataConsentUser>();
		logger.debug("getting all DataConsentUser instances");
        instances = getSession().createCriteria(DataConsentUser.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<DataConsentUser>) instances;
    }


	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<DataConsentUser> findByExample(DataConsentUser instance) {
        logger.debug("finding DataConsentUser instance by example");
        List<DataConsentUser> results = (List<DataConsentUser>) getSession()
                .createCriteria(DataConsentUser.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentUser> findByFieldParcial(DataConsentUser.Fields field, String value) {
        logger.debug("finding DataConsentUser instance by parcial value: "+field+" like "+value);
        List<DataConsentUser> results = (List<DataConsentUser>) getSession()
                .createCriteria(DataConsentUser.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

