package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEcommercePaymentsDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class EcommercePayments.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class EcommercePaymentsDAOImpl implements IEcommercePaymentsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the EcommercePayments entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EcommercePayments> getEcommercePaymentsDataSet()
    {
        return new HibernateDataSet<EcommercePayments>(EcommercePayments.class, this, EcommercePayments.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public EcommercePaymentsDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a EcommercePayments object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(EcommercePayments transientInstance) {
        logger.debug("persisting EcommercePayments instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified EcommercePayments in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(EcommercePayments instance) {
        logger.debug("attaching dirty EcommercePayments instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified EcommercePayments instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(EcommercePayments instance) {
        logger.debug("attaching clean EcommercePayments instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a EcommercePayments instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(EcommercePayments persistentInstance) {
        logger.debug("deleting EcommercePayments instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a EcommercePayments instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public EcommercePayments merge(EcommercePayments detachedInstance) {
        logger.debug("merging EcommercePayments instance");
        EcommercePayments result = (EcommercePayments) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a EcommercePayments instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public EcommercePayments findById( java.lang.Long id) {
        logger.debug("getting EcommercePayments instance with id: " + id);
        EcommercePayments instance = (EcommercePayments) getSession()
                .get(EcommercePayments.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EcommercePayments> findAll() {

 		List<EcommercePayments> instances = new ArrayList<EcommercePayments>();
		logger.debug("getting all EcommercePayments instances");
        instances = getSession().createCriteria(EcommercePayments.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<EcommercePayments>) instances;
    }


	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<EcommercePayments> findByExample(EcommercePayments instance) {
        logger.debug("finding EcommercePayments instance by example");
        List<EcommercePayments> results = (List<EcommercePayments>) getSession()
                .createCriteria(EcommercePayments.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EcommercePayments> findByFieldParcial(EcommercePayments.Fields field, String value) {
        logger.debug("finding EcommercePayments instance by parcial value: "+field+" like "+value);
        List<EcommercePayments> results = (List<EcommercePayments>) getSession()
                .createCriteria(EcommercePayments.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

