package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Event.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Event
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class EventDAOImpl implements IEventDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Event entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Event> getEventDataSet()
    {
        return new HibernateDataSet<Event>(Event.class, this, Event.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public EventDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Event object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Event transientInstance) {
        logger.debug("persisting Event instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Event in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Event instance) {
        logger.debug("attaching dirty Event instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Event instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Event instance) {
        logger.debug("attaching clean Event instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Event instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Event persistentInstance) {
        logger.debug("deleting Event instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Event instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Event merge(Event detachedInstance) {
        logger.debug("merging Event instance");
        Event result = (Event) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Event instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Event findById( java.lang.Long id) {
        logger.debug("getting Event instance with id: " + id);
        Event instance = (Event) getSession()
                .get(Event.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Event instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Event> findAll() {

 		List<Event> instances = new ArrayList<Event>();
		logger.debug("getting all Event instances");
        instances = getSession().createCriteria(Event.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Event>) instances;
    }


	/**
	 * Gets a {@link List} of all Event instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Event> findByExample(Event instance) {
        logger.debug("finding Event instance by example");
        List<Event> results = (List<Event>) getSession()
                .createCriteria(Event.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Event instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Event> findByFieldParcial(Event.Fields field, String value) {
        logger.debug("finding Event instance by parcial value: "+field+" like "+value);
        List<Event> results = (List<Event>) getSession()
                .createCriteria(Event.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

