package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.EventLogProcess;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventLogProcessDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class EventLogProcess.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.EventLogProcess
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class EventLogProcessDAOImpl implements IEventLogProcessDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the EventLogProcess entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventLogProcess> getEventLogProcessDataSet()
    {
        return new HibernateDataSet<EventLogProcess>(EventLogProcess.class, this, EventLogProcess.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public EventLogProcessDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a EventLogProcess object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(EventLogProcess transientInstance) {
        logger.debug("persisting EventLogProcess instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified EventLogProcess in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(EventLogProcess instance) {
        logger.debug("attaching dirty EventLogProcess instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified EventLogProcess instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(EventLogProcess instance) {
        logger.debug("attaching clean EventLogProcess instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a EventLogProcess instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(EventLogProcess persistentInstance) {
        logger.debug("deleting EventLogProcess instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a EventLogProcess instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public EventLogProcess merge(EventLogProcess detachedInstance) {
        logger.debug("merging EventLogProcess instance");
        EventLogProcess result = (EventLogProcess) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a EventLogProcess instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public EventLogProcess findById( java.lang.Long id) {
        logger.debug("getting EventLogProcess instance with id: " + id);
        EventLogProcess instance = (EventLogProcess) getSession()
                .get(EventLogProcess.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all EventLogProcess instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EventLogProcess> findAll() {

 		List<EventLogProcess> instances = new ArrayList<EventLogProcess>();
		logger.debug("getting all EventLogProcess instances");
        instances = getSession().createCriteria(EventLogProcess.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<EventLogProcess>) instances;
    }


	/**
	 * Gets a {@link List} of all EventLogProcess instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<EventLogProcess> findByExample(EventLogProcess instance) {
        logger.debug("finding EventLogProcess instance by example");
        List<EventLogProcess> results = (List<EventLogProcess>) getSession()
                .createCriteria(EventLogProcess.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all EventLogProcess instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EventLogProcess> findByFieldParcial(EventLogProcess.Fields field, String value) {
        logger.debug("finding EventLogProcess instance by parcial value: "+field+" like "+value);
        List<EventLogProcess> results = (List<EventLogProcess>) getSession()
                .createCriteria(EventLogProcess.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

