package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventSubscriptionDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class EventSubscription.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class EventSubscriptionDAOImpl implements IEventSubscriptionDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the EventSubscription entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventSubscription> getEventSubscriptionDataSet()
    {
        return new HibernateDataSet<EventSubscription>(EventSubscription.class, this, EventSubscription.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public EventSubscriptionDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a EventSubscription object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(EventSubscription transientInstance) {
        logger.debug("persisting EventSubscription instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified EventSubscription in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(EventSubscription instance) {
        logger.debug("attaching dirty EventSubscription instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified EventSubscription instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(EventSubscription instance) {
        logger.debug("attaching clean EventSubscription instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a EventSubscription instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(EventSubscription persistentInstance) {
        logger.debug("deleting EventSubscription instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a EventSubscription instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public EventSubscription merge(EventSubscription detachedInstance) {
        logger.debug("merging EventSubscription instance");
        EventSubscription result = (EventSubscription) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a EventSubscription instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public EventSubscription findById( java.lang.Long id) {
        logger.debug("getting EventSubscription instance with id: " + id);
        EventSubscription instance = (EventSubscription) getSession()
                .get(EventSubscription.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all EventSubscription instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EventSubscription> findAll() {

 		List<EventSubscription> instances = new ArrayList<EventSubscription>();
		logger.debug("getting all EventSubscription instances");
        instances = getSession().createCriteria(EventSubscription.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<EventSubscription>) instances;
    }


	/**
	 * Gets a {@link List} of all EventSubscription instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<EventSubscription> findByExample(EventSubscription instance) {
        logger.debug("finding EventSubscription instance by example");
        List<EventSubscription> results = (List<EventSubscription>) getSession()
                .createCriteria(EventSubscription.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all EventSubscription instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<EventSubscription> findByFieldParcial(EventSubscription.Fields field, String value) {
        logger.debug("finding EventSubscription instance by parcial value: "+field+" like "+value);
        List<EventSubscription> results = (List<EventSubscription>) getSession()
                .createCriteria(EventSubscription.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

