package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IIndicatorDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Indicator.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Indicator
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class IndicatorDAOImpl implements IIndicatorDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet()
    {
        return new HibernateDataSet<Indicator>(Indicator.class, this, Indicator.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public IndicatorDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Indicator object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Indicator transientInstance) {
        logger.debug("persisting Indicator instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Indicator in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Indicator instance) {
        logger.debug("attaching dirty Indicator instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Indicator instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Indicator instance) {
        logger.debug("attaching clean Indicator instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Indicator instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Indicator persistentInstance) {
        logger.debug("deleting Indicator instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Indicator instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Indicator merge(Indicator detachedInstance) {
        logger.debug("merging Indicator instance");
        Indicator result = (Indicator) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Indicator instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Indicator findById( java.lang.Long id) {
        logger.debug("getting Indicator instance with id: " + id);
        Indicator instance = (Indicator) getSession()
                .get(Indicator.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Indicator> findAll() {

 		List<Indicator> instances = new ArrayList<Indicator>();
		logger.debug("getting all Indicator instances");
        instances = getSession().createCriteria(Indicator.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Indicator>) instances;
    }


	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Indicator> findByExample(Indicator instance) {
        logger.debug("finding Indicator instance by example");
        List<Indicator> results = (List<Indicator>) getSession()
                .createCriteria(Indicator.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value) {
        logger.debug("finding Indicator instance by parcial value: "+field+" like "+value);
        List<Indicator> results = (List<Indicator>) getSession()
                .createCriteria(Indicator.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

