package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IManagerDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Manager.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Manager
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ManagerDAOImpl implements IManagerDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Manager entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Manager> getManagerDataSet()
    {
        return new HibernateDataSet<Manager>(Manager.class, this, Manager.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ManagerDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Manager object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Manager transientInstance) {
        logger.debug("persisting Manager instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Manager in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Manager instance) {
        logger.debug("attaching dirty Manager instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Manager instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Manager instance) {
        logger.debug("attaching clean Manager instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Manager instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Manager persistentInstance) {
        logger.debug("deleting Manager instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Manager instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Manager merge(Manager detachedInstance) {
        logger.debug("merging Manager instance");
        Manager result = (Manager) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Manager instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Manager findById( java.lang.Long id) {
        logger.debug("getting Manager instance with id: " + id);
        Manager instance = (Manager) getSession()
                .get(Manager.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Manager> findAll() {

 		List<Manager> instances = new ArrayList<Manager>();
		logger.debug("getting all Manager instances");
        instances = getSession().createCriteria(Manager.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Manager>) instances;
    }


	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Manager> findByExample(Manager instance) {
        logger.debug("finding Manager instance by example");
        List<Manager> results = (List<Manager>) getSession()
                .createCriteria(Manager.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Manager instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Manager> findByFieldParcial(Manager.Fields field, String value) {
        logger.debug("finding Manager instance by parcial value: "+field+" like "+value);
        List<Manager> results = (List<Manager>) getSession()
                .createCriteria(Manager.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

