package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceDocument;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IReportInstanceDocumentDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportInstanceDocument.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceDocument
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ReportInstanceDocumentDAOImpl implements IReportInstanceDocumentDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportInstanceDocument entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceDocument> getReportInstanceDocumentDataSet()
    {
        return new HibernateDataSet<ReportInstanceDocument>(ReportInstanceDocument.class, this, ReportInstanceDocument.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ReportInstanceDocumentDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportInstanceDocument object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstanceDocument transientInstance) {
        logger.debug("persisting ReportInstanceDocument instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportInstanceDocument in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstanceDocument instance) {
        logger.debug("attaching dirty ReportInstanceDocument instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportInstanceDocument instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstanceDocument instance) {
        logger.debug("attaching clean ReportInstanceDocument instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportInstanceDocument instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstanceDocument persistentInstance) {
        logger.debug("deleting ReportInstanceDocument instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportInstanceDocument instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstanceDocument merge(ReportInstanceDocument detachedInstance) {
        logger.debug("merging ReportInstanceDocument instance");
        ReportInstanceDocument result = (ReportInstanceDocument) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportInstanceDocument instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstanceDocument findById( java.lang.Long id) {
        logger.debug("getting ReportInstanceDocument instance with id: " + id);
        ReportInstanceDocument instance = (ReportInstanceDocument) getSession()
                .get(ReportInstanceDocument.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportInstanceDocument instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceDocument> findAll() {

 		List<ReportInstanceDocument> instances = new ArrayList<ReportInstanceDocument>();
		logger.debug("getting all ReportInstanceDocument instances");
        instances = getSession().createCriteria(ReportInstanceDocument.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportInstanceDocument>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceDocument instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportInstanceDocument> findByExample(ReportInstanceDocument instance) {
        logger.debug("finding ReportInstanceDocument instance by example");
        List<ReportInstanceDocument> results = (List<ReportInstanceDocument>) getSession()
                .createCriteria(ReportInstanceDocument.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportInstanceDocument instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceDocument> findByFieldParcial(ReportInstanceDocument.Fields field, String value) {
        logger.debug("finding ReportInstanceDocument instance by parcial value: "+field+" like "+value);
        List<ReportInstanceDocument> results = (List<ReportInstanceDocument>) getSession()
                .createCriteria(ReportInstanceDocument.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

