package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateArea;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IReportTemplateAreaDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportTemplateArea.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateArea
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ReportTemplateAreaDAOImpl implements IReportTemplateAreaDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportTemplateArea entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateArea> getReportTemplateAreaDataSet()
    {
        return new HibernateDataSet<ReportTemplateArea>(ReportTemplateArea.class, this, ReportTemplateArea.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ReportTemplateAreaDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportTemplateArea object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportTemplateArea transientInstance) {
        logger.debug("persisting ReportTemplateArea instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportTemplateArea in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportTemplateArea instance) {
        logger.debug("attaching dirty ReportTemplateArea instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportTemplateArea instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportTemplateArea instance) {
        logger.debug("attaching clean ReportTemplateArea instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportTemplateArea instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportTemplateArea persistentInstance) {
        logger.debug("deleting ReportTemplateArea instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportTemplateArea instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportTemplateArea merge(ReportTemplateArea detachedInstance) {
        logger.debug("merging ReportTemplateArea instance");
        ReportTemplateArea result = (ReportTemplateArea) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportTemplateArea instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportTemplateArea findById( java.lang.Long id) {
        logger.debug("getting ReportTemplateArea instance with id: " + id);
        ReportTemplateArea instance = (ReportTemplateArea) getSession()
                .get(ReportTemplateArea.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportTemplateArea instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateArea> findAll() {

 		List<ReportTemplateArea> instances = new ArrayList<ReportTemplateArea>();
		logger.debug("getting all ReportTemplateArea instances");
        instances = getSession().createCriteria(ReportTemplateArea.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportTemplateArea>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportTemplateArea instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportTemplateArea> findByExample(ReportTemplateArea instance) {
        logger.debug("finding ReportTemplateArea instance by example");
        List<ReportTemplateArea> results = (List<ReportTemplateArea>) getSession()
                .createCriteria(ReportTemplateArea.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportTemplateArea instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateArea> findByFieldParcial(ReportTemplateArea.Fields field, String value) {
        logger.debug("finding ReportTemplateArea instance by parcial value: "+field+" like "+value);
        List<ReportTemplateArea> results = (List<ReportTemplateArea>) getSession()
                .createCriteria(ReportTemplateArea.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

