package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IServerMessageDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ServerMessage.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ServerMessageDAOImpl implements IServerMessageDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ServerMessage entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerMessage> getServerMessageDataSet()
    {
        return new HibernateDataSet<ServerMessage>(ServerMessage.class, this, ServerMessage.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ServerMessageDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ServerMessage object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ServerMessage transientInstance) {
        logger.debug("persisting ServerMessage instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ServerMessage in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ServerMessage instance) {
        logger.debug("attaching dirty ServerMessage instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ServerMessage instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ServerMessage instance) {
        logger.debug("attaching clean ServerMessage instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ServerMessage instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ServerMessage persistentInstance) {
        logger.debug("deleting ServerMessage instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ServerMessage instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ServerMessage merge(ServerMessage detachedInstance) {
        logger.debug("merging ServerMessage instance");
        ServerMessage result = (ServerMessage) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ServerMessage instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ServerMessage findById( java.lang.Long id) {
        logger.debug("getting ServerMessage instance with id: " + id);
        ServerMessage instance = (ServerMessage) getSession()
                .get(ServerMessage.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ServerMessage instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ServerMessage> findAll() {

 		List<ServerMessage> instances = new ArrayList<ServerMessage>();
		logger.debug("getting all ServerMessage instances");
        instances = getSession().createCriteria(ServerMessage.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ServerMessage>) instances;
    }


	/**
	 * Gets a {@link List} of all ServerMessage instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ServerMessage> findByExample(ServerMessage instance) {
        logger.debug("finding ServerMessage instance by example");
        List<ServerMessage> results = (List<ServerMessage>) getSession()
                .createCriteria(ServerMessage.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ServerMessage instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ServerMessage> findByFieldParcial(ServerMessage.Fields field, String value) {
        logger.debug("finding ServerMessage instance by parcial value: "+field+" like "+value);
        List<ServerMessage> results = (List<ServerMessage>) getSession()
                .createCriteria(ServerMessage.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

