package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.ITemplateRepositoryDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class TemplateRepository.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class TemplateRepositoryDAOImpl implements ITemplateRepositoryDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the TemplateRepository entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<TemplateRepository> getTemplateRepositoryDataSet()
    {
        return new HibernateDataSet<TemplateRepository>(TemplateRepository.class, this, TemplateRepository.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public TemplateRepositoryDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a TemplateRepository object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(TemplateRepository transientInstance) {
        logger.debug("persisting TemplateRepository instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified TemplateRepository in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(TemplateRepository instance) {
        logger.debug("attaching dirty TemplateRepository instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified TemplateRepository instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(TemplateRepository instance) {
        logger.debug("attaching clean TemplateRepository instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a TemplateRepository instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(TemplateRepository persistentInstance) {
        logger.debug("deleting TemplateRepository instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a TemplateRepository instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public TemplateRepository merge(TemplateRepository detachedInstance) {
        logger.debug("merging TemplateRepository instance");
        TemplateRepository result = (TemplateRepository) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a TemplateRepository instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public TemplateRepository findById( java.lang.Long id) {
        logger.debug("getting TemplateRepository instance with id: " + id);
        TemplateRepository instance = (TemplateRepository) getSession()
                .get(TemplateRepository.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<TemplateRepository> findAll() {

 		List<TemplateRepository> instances = new ArrayList<TemplateRepository>();
		logger.debug("getting all TemplateRepository instances");
        instances = getSession().createCriteria(TemplateRepository.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<TemplateRepository>) instances;
    }


	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<TemplateRepository> findByExample(TemplateRepository instance) {
        logger.debug("finding TemplateRepository instance by example");
        List<TemplateRepository> results = (List<TemplateRepository>) getSession()
                .createCriteria(TemplateRepository.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all TemplateRepository instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<TemplateRepository> findByFieldParcial(TemplateRepository.Fields field, String value) {
        logger.debug("finding TemplateRepository instance by parcial value: "+field+" like "+value);
        List<TemplateRepository> results = (List<TemplateRepository>) getSession()
                .createCriteria(TemplateRepository.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

