package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * ConfigSet
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class ConfigSet extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** ConfigSet attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** name column */
        public static final String NAME = "name";
        /** description column */
        public static final String DESCRIPTION = "description";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * configNodes relation.
         *
         * @return the configNodes bean relations attributes.
         */
        public ConfigNode.Relations configNodes()
        {
			ConfigNode c = new ConfigNode();
            return c.new Relations(this.buildPath("configNodes"));
        }
        
        /**
         * configServerSets relation.
         *
         * @return the configServerSets bean relations attributes.
         */
        public ConfigServerSet.Relations configServerSets()
        {
			ConfigServerSet c = new ConfigServerSet();
            return c.new Relations(this.buildPath("configServerSets"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
		/**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
    }
	
	/** The dummy obj. */
    private static ConfigSet dummyObj = new ConfigSet();

	/**
     * Get ConfigSet Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("configNodes".equalsIgnoreCase(attributeName))
            return configNodes;
        if ("configServerSets".equalsIgnoreCase(attributeName))
            return configServerSets;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String)attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String)attributeValue;
        if ("configNodes".equalsIgnoreCase(attributeName))
            configNodes = (Set<ConfigNode>)attributeValue;
        if ("configServerSets".equalsIgnoreCase(attributeName))
            configServerSets = (Set<ConfigServerSet>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** configNodes private attribute */
    private Set<ConfigNode> configNodes = new HashSet<ConfigNode>(0);

    /** configServerSets private attribute */
    private Set<ConfigServerSet> configServerSets = new HashSet<ConfigServerSet>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ConfigSet() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name
    }
	 */
    public ConfigSet(String name) {
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param name
     * @param description
     * @param configNodes
     * @param configServerSets
     */
    public ConfigSet(String name, String description, Set<ConfigNode> configNodes, Set<ConfigServerSet> configServerSets) {
        this.name = name;
        this.description = description;
        this.configNodes = configNodes;
        this.configServerSets = configServerSets;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * configNodes getter method
     *
     * @return configNodes method
     */
    public Set<ConfigNode> getConfigNodes() {
        return this.configNodes;
    }
    
    /**       
     * configNodes setter method
     *
     * @param configNodes
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setConfigNodes(Set<ConfigNode> configNodes) {
        this.configNodes = configNodes;
        
        return this;
    }
    /**       
     * configServerSets getter method
     *
     * @return configServerSets method
     */
    public Set<ConfigServerSet> getConfigServerSets() {
        return this.configServerSets;
    }
    
    /**       
     * configServerSets setter method
     *
     * @param configServerSets
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setConfigServerSets(Set<ConfigServerSet> configServerSets) {
        this.configServerSets = configServerSets;
        
        return this;
    }

    /**
     * Creates a String representation of the ConfigSet object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ConfigSet object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ConfigSet other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

    }


}
