package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * Event
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class Event extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** Event attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** configId column */
        public static final String CONFIGID = "configId";
        /** applicationId column */
        public static final String APPLICATIONID = "applicationId";
        /** categoryId column */
        public static final String CATEGORYID = "categoryId";
        /** businessId column */
        public static final String BUSINESSID = "businessId";
        /** eventDate column */
        public static final String EVENTDATE = "eventDate";
        /** state column */
        public static final String STATE = "state";
        /** publisherId column */
        public static final String PUBLISHERID = "publisherId";
        /** userIdThatTriggeredEvent column */
        public static final String USERIDTHATTRIGGEREDEVENT = "userIdThatTriggeredEvent";
        /** payLoad column */
        public static final String PAYLOAD = "payLoad";
        /** attemptsToGiveUp column */
        public static final String ATTEMPTSTOGIVEUP = "attemptsToGiveUp";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("applicationId");
            list.add("categoryId");
            list.add("businessId");
            list.add("eventDate");
            list.add("state");
            list.add("publisherId");
            list.add("userIdThatTriggeredEvent");
            list.add("payLoad");
            list.add("attemptsToGiveUp");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * eventLogProcesses relation.
         *
         * @return the eventLogProcesses bean relations attributes.
         */
        public EventLogProcess.Relations eventLogProcesses()
        {
			EventLogProcess c = new EventLogProcess();
            return c.new Relations(this.buildPath("eventLogProcesses"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
		/**
         * the APPLICATIONID path.
         *
         * @return the path
         */
        public String APPLICATIONID()
        {
            return buildPath(Fields.APPLICATIONID);
        }
		/**
         * the CATEGORYID path.
         *
         * @return the path
         */
        public String CATEGORYID()
        {
            return buildPath(Fields.CATEGORYID);
        }
		/**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
		/**
         * the EVENTDATE path.
         *
         * @return the path
         */
        public String EVENTDATE()
        {
            return buildPath(Fields.EVENTDATE);
        }
		/**
         * the STATE path.
         *
         * @return the path
         */
        public String STATE()
        {
            return buildPath(Fields.STATE);
        }
		/**
         * the PUBLISHERID path.
         *
         * @return the path
         */
        public String PUBLISHERID()
        {
            return buildPath(Fields.PUBLISHERID);
        }
		/**
         * the USERIDTHATTRIGGEREDEVENT path.
         *
         * @return the path
         */
        public String USERIDTHATTRIGGEREDEVENT()
        {
            return buildPath(Fields.USERIDTHATTRIGGEREDEVENT);
        }
		/**
         * the PAYLOAD path.
         *
         * @return the path
         */
        public String PAYLOAD()
        {
            return buildPath(Fields.PAYLOAD);
        }
		/**
         * the ATTEMPTSTOGIVEUP path.
         *
         * @return the path
         */
        public String ATTEMPTSTOGIVEUP()
        {
            return buildPath(Fields.ATTEMPTSTOGIVEUP);
        }
    }
	
	/** The dummy obj. */
    private static Event dummyObj = new Event();

	/**
     * Get Event Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("configId".equalsIgnoreCase(attributeName))
            return configId;
        if ("applicationId".equalsIgnoreCase(attributeName))
            return applicationId;
        if ("categoryId".equalsIgnoreCase(attributeName))
            return categoryId;
        if ("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if ("eventDate".equalsIgnoreCase(attributeName))
            return eventDate;
        if ("state".equalsIgnoreCase(attributeName))
            return state;
        if ("publisherId".equalsIgnoreCase(attributeName))
            return publisherId;
        if ("userIdThatTriggeredEvent".equalsIgnoreCase(attributeName))
            return userIdThatTriggeredEvent;
        if ("payLoad".equalsIgnoreCase(attributeName))
            return payLoad;
        if ("attemptsToGiveUp".equalsIgnoreCase(attributeName))
            return attemptsToGiveUp;
        if ("eventLogProcesses".equalsIgnoreCase(attributeName))
            return eventLogProcesses;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("configId".equalsIgnoreCase(attributeName))
            configId = (String)attributeValue;
        if ("applicationId".equalsIgnoreCase(attributeName))
            applicationId = (String)attributeValue;
        if ("categoryId".equalsIgnoreCase(attributeName))
            categoryId = (String)attributeValue;
        if ("businessId".equalsIgnoreCase(attributeName))
            businessId = (String)attributeValue;
        if ("eventDate".equalsIgnoreCase(attributeName))
            eventDate = (Timestamp)attributeValue;
        if ("state".equalsIgnoreCase(attributeName))
            state = (String)attributeValue;
        if ("publisherId".equalsIgnoreCase(attributeName))
            publisherId = (String)attributeValue;
        if ("userIdThatTriggeredEvent".equalsIgnoreCase(attributeName))
            userIdThatTriggeredEvent = (String)attributeValue;
        if ("payLoad".equalsIgnoreCase(attributeName))
            payLoad = (String)attributeValue;
        if ("attemptsToGiveUp".equalsIgnoreCase(attributeName))
            attemptsToGiveUp = (Long)attributeValue;
        if ("eventLogProcesses".equalsIgnoreCase(attributeName))
            eventLogProcesses = (Set<EventLogProcess>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configId private attribute */
    private String configId;

    /** applicationId private attribute */
    private String applicationId;

    /** categoryId private attribute */
    private String categoryId;

    /** businessId private attribute */
    private String businessId;

    /** eventDate private attribute */
    private Timestamp eventDate;

    /** state private attribute */
    private String state;

    /** publisherId private attribute */
    private String publisherId;

    /** userIdThatTriggeredEvent private attribute */
    private String userIdThatTriggeredEvent;

    /** payLoad private attribute */
    private String payLoad;

    /** attemptsToGiveUp private attribute */
    private Long attemptsToGiveUp;

    /** eventLogProcesses private attribute */
    private Set<EventLogProcess> eventLogProcesses = new HashSet<EventLogProcess>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Event() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId
    }
	 */
    public Event(String configId) {
        this.configId = configId;
    }

    /**
     * full constructor
	 *
     * @param configId
     * @param applicationId
     * @param categoryId
     * @param businessId
     * @param eventDate
     * @param state
     * @param publisherId
     * @param userIdThatTriggeredEvent
     * @param payLoad
     * @param attemptsToGiveUp
     * @param eventLogProcesses
     */
    public Event(String configId, String applicationId, String categoryId, String businessId, Timestamp eventDate, String state, String publisherId, String userIdThatTriggeredEvent, String payLoad, Long attemptsToGiveUp, Set<EventLogProcess> eventLogProcesses) {
        this.configId = configId;
        this.applicationId = applicationId;
        this.categoryId = categoryId;
        this.businessId = businessId;
        this.eventDate = eventDate;
        this.state = state;
        this.publisherId = publisherId;
        this.userIdThatTriggeredEvent = userIdThatTriggeredEvent;
        this.payLoad = payLoad;
        this.attemptsToGiveUp = attemptsToGiveUp;
        this.eventLogProcesses = eventLogProcesses;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return Event modified instance
     */
    public Event setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId
     *
     * @return Event modified instance
     */
    public Event setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * applicationId getter method
     *
     * @return applicationId method
     */
    public String getApplicationId() {
        return this.applicationId;
    }
    
    /**       
     * applicationId setter method
     *
     * @param applicationId
     *
     * @return Event modified instance
     */
    public Event setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        
        return this;
    }
    /**       
     * categoryId getter method
     *
     * @return categoryId method
     */
    public String getCategoryId() {
        return this.categoryId;
    }
    
    /**       
     * categoryId setter method
     *
     * @param categoryId
     *
     * @return Event modified instance
     */
    public Event setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId
     *
     * @return Event modified instance
     */
    public Event setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * eventDate getter method
     *
     * @return eventDate method
     */
    public Timestamp getEventDate() {
        return this.eventDate;
    }
    
    /**       
     * eventDate setter method
     *
     * @param eventDate
     *
     * @return Event modified instance
     */
    public Event setEventDate(Timestamp eventDate) {
        this.eventDate = eventDate;
        
        return this;
    }
    /**       
     * state getter method
     *
     * @return state method
     */
    public String getState() {
        return this.state;
    }
    
    /**       
     * state setter method
     *
     * @param state
     *
     * @return Event modified instance
     */
    public Event setState(String state) {
        this.state = state;
        
        return this;
    }
    /**       
     * publisherId getter method
     *
     * @return publisherId method
     */
    public String getPublisherId() {
        return this.publisherId;
    }
    
    /**       
     * publisherId setter method
     *
     * @param publisherId
     *
     * @return Event modified instance
     */
    public Event setPublisherId(String publisherId) {
        this.publisherId = publisherId;
        
        return this;
    }
    /**       
     * userIdThatTriggeredEvent getter method
     *
     * @return userIdThatTriggeredEvent method
     */
    public String getUserIdThatTriggeredEvent() {
        return this.userIdThatTriggeredEvent;
    }
    
    /**       
     * userIdThatTriggeredEvent setter method
     *
     * @param userIdThatTriggeredEvent
     *
     * @return Event modified instance
     */
    public Event setUserIdThatTriggeredEvent(String userIdThatTriggeredEvent) {
        this.userIdThatTriggeredEvent = userIdThatTriggeredEvent;
        
        return this;
    }
    /**       
     * payLoad getter method
     *
     * @return payLoad method
     */
    public String getPayLoad() {
        return this.payLoad;
    }
    
    /**       
     * payLoad setter method
     *
     * @param payLoad
     *
     * @return Event modified instance
     */
    public Event setPayLoad(String payLoad) {
        this.payLoad = payLoad;
        
        return this;
    }
    /**       
     * attemptsToGiveUp getter method
     *
     * @return attemptsToGiveUp method
     */
    public Long getAttemptsToGiveUp() {
        return this.attemptsToGiveUp;
    }
    
    /**       
     * attemptsToGiveUp setter method
     *
     * @param attemptsToGiveUp
     *
     * @return Event modified instance
     */
    public Event setAttemptsToGiveUp(Long attemptsToGiveUp) {
        this.attemptsToGiveUp = attemptsToGiveUp;
        
        return this;
    }
    /**       
     * eventLogProcesses getter method
     *
     * @return eventLogProcesses method
     */
    public Set<EventLogProcess> getEventLogProcesses() {
        return this.eventLogProcesses;
    }
    
    /**       
     * eventLogProcesses setter method
     *
     * @param eventLogProcesses
     *
     * @return Event modified instance
     */
    public Event setEventLogProcesses(Set<EventLogProcess> eventLogProcesses) {
        this.eventLogProcesses = eventLogProcesses;
        
        return this;
    }

    /**
     * Creates a String representation of the Event object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("applicationId").append("='").append(getApplicationId()).append("' ");			
        buffer.append("categoryId").append("='").append(getCategoryId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("eventDate").append("='").append(getEventDate()).append("' ");			
        buffer.append("state").append("='").append(getState()).append("' ");			
        buffer.append("publisherId").append("='").append(getPublisherId()).append("' ");			
        buffer.append("userIdThatTriggeredEvent").append("='").append(getUserIdThatTriggeredEvent()).append("' ");			
        buffer.append("payLoad").append("='").append(getPayLoad()).append("' ");			
        buffer.append("attemptsToGiveUp").append("='").append(getAttemptsToGiveUp()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Event object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Event other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("applicationId".equalsIgnoreCase(attributeName))
        	this.applicationId = attributeValue;

        if ("categoryId".equalsIgnoreCase(attributeName))
        	this.categoryId = attributeValue;

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("eventDate".equalsIgnoreCase(attributeName))
            this.eventDate = Timestamp.valueOf(attributeValue);

        if ("state".equalsIgnoreCase(attributeName))
        	this.state = attributeValue;

        if ("publisherId".equalsIgnoreCase(attributeName))
        	this.publisherId = attributeValue;

        if ("userIdThatTriggeredEvent".equalsIgnoreCase(attributeName))
        	this.userIdThatTriggeredEvent = attributeValue;

        if ("payLoad".equalsIgnoreCase(attributeName))
        	this.payLoad = attributeValue;

        if ("attemptsToGiveUp".equalsIgnoreCase(attributeName))
            this.attemptsToGiveUp = Long.valueOf(attributeValue);

    }


}
