package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * ReportInstance
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class ReportInstance extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** ReportInstance attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** title column */
        public static final String TITLE = "title";
        /** readonly column */
        public static final String READONLY = "readonly";
        /** businessKey column */
        public static final String BUSINESSKEY = "businessKey";
        /** documentId column */
        public static final String DOCUMENTID = "documentId";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("title");
            list.add("readonly");
            list.add("businessKey");
            list.add("documentId");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * reportTemplate relation.
         *
         * @return the reportTemplate bean relations attributes.
         */
        public ReportTemplate.Relations reportTemplate()
        {
			ReportTemplate c = new ReportTemplate();
            return c.new Relations(this.buildPath("reportTemplate"));
        }
        
        /**
         * reportInstanceDocuments relation.
         *
         * @return the reportInstanceDocuments bean relations attributes.
         */
        public ReportInstanceDocument.Relations reportInstanceDocuments()
        {
			ReportInstanceDocument c = new ReportInstanceDocument();
            return c.new Relations(this.buildPath("reportInstanceDocuments"));
        }
        
        /**
         * reportInstanceAreas relation.
         *
         * @return the reportInstanceAreas bean relations attributes.
         */
        public ReportInstanceArea.Relations reportInstanceAreas()
        {
			ReportInstanceArea c = new ReportInstanceArea();
            return c.new Relations(this.buildPath("reportInstanceAreas"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the TITLE path.
         *
         * @return the path
         */
        public String TITLE()
        {
            return buildPath(Fields.TITLE);
        }
		/**
         * the READONLY path.
         *
         * @return the path
         */
        public String READONLY()
        {
            return buildPath(Fields.READONLY);
        }
		/**
         * the BUSINESSKEY path.
         *
         * @return the path
         */
        public String BUSINESSKEY()
        {
            return buildPath(Fields.BUSINESSKEY);
        }
		/**
         * the DOCUMENTID path.
         *
         * @return the path
         */
        public String DOCUMENTID()
        {
            return buildPath(Fields.DOCUMENTID);
        }
    }
	
	/** The dummy obj. */
    private static ReportInstance dummyObj = new ReportInstance();

	/**
     * Get ReportInstance Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("reportTemplate".equalsIgnoreCase(attributeName))
            return reportTemplate;
        if ("title".equalsIgnoreCase(attributeName))
            return title;
        if ("readonly".equalsIgnoreCase(attributeName))
            return readonly;
        if ("businessKey".equalsIgnoreCase(attributeName))
            return businessKey;
        if ("documentId".equalsIgnoreCase(attributeName))
            return documentId;
        if ("reportInstanceDocuments".equalsIgnoreCase(attributeName))
            return reportInstanceDocuments;
        if ("reportInstanceAreas".equalsIgnoreCase(attributeName))
            return reportInstanceAreas;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("reportTemplate".equalsIgnoreCase(attributeName))
            reportTemplate = (ReportTemplate)attributeValue;
        if ("title".equalsIgnoreCase(attributeName))
            title = (String)attributeValue;
        if ("readonly".equalsIgnoreCase(attributeName))
            readonly = (Boolean)attributeValue;
        if ("businessKey".equalsIgnoreCase(attributeName))
            businessKey = (String)attributeValue;
        if ("documentId".equalsIgnoreCase(attributeName))
            documentId = (Long)attributeValue;
        if ("reportInstanceDocuments".equalsIgnoreCase(attributeName))
            reportInstanceDocuments = (Set<ReportInstanceDocument>)attributeValue;
        if ("reportInstanceAreas".equalsIgnoreCase(attributeName))
            reportInstanceAreas = (Set<ReportInstanceArea>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** reportTemplate private attribute */
    private ReportTemplate reportTemplate;

    /** title private attribute */
    private String title;

    /** readonly private attribute */
    private boolean readonly;

    /** businessKey private attribute */
    private String businessKey;

    /** documentId private attribute */
    private Long documentId;

    /** reportInstanceDocuments private attribute */
    private Set<ReportInstanceDocument> reportInstanceDocuments = new HashSet<ReportInstanceDocument>(0);

    /** reportInstanceAreas private attribute */
    private Set<ReportInstanceArea> reportInstanceAreas = new HashSet<ReportInstanceArea>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ReportInstance() {
    }

	/** 
	 * minimal constructor
	 *
     * @param reportTemplate
     * @param title
     * @param readonly
    }
	 */
    public ReportInstance(ReportTemplate reportTemplate, String title, boolean readonly) {
        this.reportTemplate = reportTemplate;
        this.title = title;
        this.readonly = readonly;
    }

    /**
     * full constructor
	 *
     * @param reportTemplate
     * @param title
     * @param readonly
     * @param businessKey
     * @param documentId
     * @param reportInstanceDocuments
     * @param reportInstanceAreas
     */
    public ReportInstance(ReportTemplate reportTemplate, String title, boolean readonly, String businessKey, Long documentId, Set<ReportInstanceDocument> reportInstanceDocuments, Set<ReportInstanceArea> reportInstanceAreas) {
        this.reportTemplate = reportTemplate;
        this.title = title;
        this.readonly = readonly;
        this.businessKey = businessKey;
        this.documentId = documentId;
        this.reportInstanceDocuments = reportInstanceDocuments;
        this.reportInstanceAreas = reportInstanceAreas;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * reportTemplate getter method
     *
     * @return reportTemplate method
     */
    public ReportTemplate getReportTemplate() {
        return this.reportTemplate;
    }
    
    /**       
     * reportTemplate setter method
     *
     * @param reportTemplate
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setReportTemplate(ReportTemplate reportTemplate) {
        this.reportTemplate = reportTemplate;
        
        return this;
    }
    /**       
     * title getter method
     *
     * @return title method
     */
    public String getTitle() {
        return this.title;
    }
    
    /**       
     * title setter method
     *
     * @param title
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setTitle(String title) {
        this.title = title;
        
        return this;
    }
    /**       
     * readonly getter method
     *
     * @return readonly method
     */
    public boolean isReadonly() {
        return this.readonly;
    }
    
    /**       
     * readonly setter method
     *
     * @param readonly
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setReadonly(boolean readonly) {
        this.readonly = readonly;
        
        return this;
    }
    /**       
     * businessKey getter method
     *
     * @return businessKey method
     */
    public String getBusinessKey() {
        return this.businessKey;
    }
    
    /**       
     * businessKey setter method
     *
     * @param businessKey
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        
        return this;
    }
    /**       
     * documentId getter method
     *
     * @return documentId method
     */
    public Long getDocumentId() {
        return this.documentId;
    }
    
    /**       
     * documentId setter method
     *
     * @param documentId
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setDocumentId(Long documentId) {
        this.documentId = documentId;
        
        return this;
    }
    /**       
     * reportInstanceDocuments getter method
     *
     * @return reportInstanceDocuments method
     */
    public Set<ReportInstanceDocument> getReportInstanceDocuments() {
        return this.reportInstanceDocuments;
    }
    
    /**       
     * reportInstanceDocuments setter method
     *
     * @param reportInstanceDocuments
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setReportInstanceDocuments(Set<ReportInstanceDocument> reportInstanceDocuments) {
        this.reportInstanceDocuments = reportInstanceDocuments;
        
        return this;
    }
    /**       
     * reportInstanceAreas getter method
     *
     * @return reportInstanceAreas method
     */
    public Set<ReportInstanceArea> getReportInstanceAreas() {
        return this.reportInstanceAreas;
    }
    
    /**       
     * reportInstanceAreas setter method
     *
     * @param reportInstanceAreas
     *
     * @return ReportInstance modified instance
     */
    public ReportInstance setReportInstanceAreas(Set<ReportInstanceArea> reportInstanceAreas) {
        this.reportInstanceAreas = reportInstanceAreas;
        
        return this;
    }

    /**
     * Creates a String representation of the ReportInstance object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("title").append("='").append(getTitle()).append("' ");			
        buffer.append("readonly").append("='").append(isReadonly()).append("' ");			
        buffer.append("businessKey").append("='").append(getBusinessKey()).append("' ");			
        buffer.append("documentId").append("='").append(getDocumentId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ReportInstance object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ReportInstance other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("title".equalsIgnoreCase(attributeName))
        	this.title = attributeValue;

        if ("readonly".equalsIgnoreCase(attributeName))
            this.readonly = Boolean.valueOf(attributeValue);

        if ("businessKey".equalsIgnoreCase(attributeName))
        	this.businessKey = attributeValue;

        if ("documentId".equalsIgnoreCase(attributeName))
            this.documentId = Long.valueOf(attributeValue);

    }


}
