package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * ServerMessage
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class ServerMessage extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** ServerMessage attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** message column */
        public static final String MESSAGE = "message";
        /** when column */
        public static final String WHEN = "when";
        /** answer column */
        public static final String ANSWER = "answer";
        /** processed column */
        public static final String PROCESSED = "processed";
        /** success column */
        public static final String SUCCESS = "success";
        /** elapsedTime column */
        public static final String ELAPSEDTIME = "elapsedTime";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("message");
            list.add("when");
            list.add("answer");
            list.add("processed");
            list.add("success");
            list.add("elapsedTime");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * serverByServerSenderId relation.
         *
         * @return the serverByServerSenderId bean relations attributes.
         */
        public Server.Relations serverByServerSenderId()
        {
			Server c = new Server();
            return c.new Relations(this.buildPath("serverByServerSenderId"));
        }
        
        /**
         * serverByServerReceiverId relation.
         *
         * @return the serverByServerReceiverId bean relations attributes.
         */
        public Server.Relations serverByServerReceiverId()
        {
			Server c = new Server();
            return c.new Relations(this.buildPath("serverByServerReceiverId"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the MESSAGE path.
         *
         * @return the path
         */
        public String MESSAGE()
        {
            return buildPath(Fields.MESSAGE);
        }
		/**
         * the WHEN path.
         *
         * @return the path
         */
        public String WHEN()
        {
            return buildPath(Fields.WHEN);
        }
		/**
         * the ANSWER path.
         *
         * @return the path
         */
        public String ANSWER()
        {
            return buildPath(Fields.ANSWER);
        }
		/**
         * the PROCESSED path.
         *
         * @return the path
         */
        public String PROCESSED()
        {
            return buildPath(Fields.PROCESSED);
        }
		/**
         * the SUCCESS path.
         *
         * @return the path
         */
        public String SUCCESS()
        {
            return buildPath(Fields.SUCCESS);
        }
		/**
         * the ELAPSEDTIME path.
         *
         * @return the path
         */
        public String ELAPSEDTIME()
        {
            return buildPath(Fields.ELAPSEDTIME);
        }
    }
	
	/** The dummy obj. */
    private static ServerMessage dummyObj = new ServerMessage();

	/**
     * Get ServerMessage Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("serverByServerSenderId".equalsIgnoreCase(attributeName))
            return serverByServerSenderId;
        if ("serverByServerReceiverId".equalsIgnoreCase(attributeName))
            return serverByServerReceiverId;
        if ("message".equalsIgnoreCase(attributeName))
            return message;
        if ("when".equalsIgnoreCase(attributeName))
            return when;
        if ("answer".equalsIgnoreCase(attributeName))
            return answer;
        if ("processed".equalsIgnoreCase(attributeName))
            return processed;
        if ("success".equalsIgnoreCase(attributeName))
            return success;
        if ("elapsedTime".equalsIgnoreCase(attributeName))
            return elapsedTime;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("serverByServerSenderId".equalsIgnoreCase(attributeName))
            serverByServerSenderId = (Server)attributeValue;
        if ("serverByServerReceiverId".equalsIgnoreCase(attributeName))
            serverByServerReceiverId = (Server)attributeValue;
        if ("message".equalsIgnoreCase(attributeName))
            message = (String)attributeValue;
        if ("when".equalsIgnoreCase(attributeName))
            when = (Timestamp)attributeValue;
        if ("answer".equalsIgnoreCase(attributeName))
            answer = (String)attributeValue;
        if ("processed".equalsIgnoreCase(attributeName))
            processed = (Boolean)attributeValue;
        if ("success".equalsIgnoreCase(attributeName))
            success = (Boolean)attributeValue;
        if ("elapsedTime".equalsIgnoreCase(attributeName))
            elapsedTime = (Long)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** serverByServerSenderId private attribute */
    private Server serverByServerSenderId;

    /** serverByServerReceiverId private attribute */
    private Server serverByServerReceiverId;

    /** message private attribute */
    private String message;

    /** when private attribute */
    private Timestamp when;

    /** answer private attribute */
    private String answer;

    /** processed private attribute */
    private boolean processed;

    /** success private attribute */
    private boolean success;

    /** elapsedTime private attribute */
    private Long elapsedTime;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ServerMessage() {
    }

	/** 
	 * minimal constructor
	 *
     * @param serverByServerSenderId
     * @param serverByServerReceiverId
     * @param message
     * @param when
     * @param processed
     * @param success
    }
	 */
    public ServerMessage(Server serverByServerSenderId, Server serverByServerReceiverId, String message, Timestamp when, boolean processed, boolean success) {
        this.serverByServerSenderId = serverByServerSenderId;
        this.serverByServerReceiverId = serverByServerReceiverId;
        this.message = message;
        this.when = when;
        this.processed = processed;
        this.success = success;
    }

    /**
     * full constructor
	 *
     * @param serverByServerSenderId
     * @param serverByServerReceiverId
     * @param message
     * @param when
     * @param answer
     * @param processed
     * @param success
     * @param elapsedTime
     */
    public ServerMessage(Server serverByServerSenderId, Server serverByServerReceiverId, String message, Timestamp when, String answer, boolean processed, boolean success, Long elapsedTime) {
        this.serverByServerSenderId = serverByServerSenderId;
        this.serverByServerReceiverId = serverByServerReceiverId;
        this.message = message;
        this.when = when;
        this.answer = answer;
        this.processed = processed;
        this.success = success;
        this.elapsedTime = elapsedTime;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * serverByServerSenderId getter method
     *
     * @return serverByServerSenderId method
     */
    public Server getServerByServerSenderId() {
        return this.serverByServerSenderId;
    }
    
    /**       
     * serverByServerSenderId setter method
     *
     * @param serverByServerSenderId
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setServerByServerSenderId(Server serverByServerSenderId) {
        this.serverByServerSenderId = serverByServerSenderId;
        
        return this;
    }
    /**       
     * serverByServerReceiverId getter method
     *
     * @return serverByServerReceiverId method
     */
    public Server getServerByServerReceiverId() {
        return this.serverByServerReceiverId;
    }
    
    /**       
     * serverByServerReceiverId setter method
     *
     * @param serverByServerReceiverId
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setServerByServerReceiverId(Server serverByServerReceiverId) {
        this.serverByServerReceiverId = serverByServerReceiverId;
        
        return this;
    }
    /**       
     * message getter method
     *
     * @return message method
     */
    public String getMessage() {
        return this.message;
    }
    
    /**       
     * message setter method
     *
     * @param message
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setMessage(String message) {
        this.message = message;
        
        return this;
    }
    /**       
     * when getter method
     *
     * @return when method
     */
    public Timestamp getWhen() {
        return this.when;
    }
    
    /**       
     * when setter method
     *
     * @param when
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setWhen(Timestamp when) {
        this.when = when;
        
        return this;
    }
    /**       
     * answer getter method
     *
     * @return answer method
     */
    public String getAnswer() {
        return this.answer;
    }
    
    /**       
     * answer setter method
     *
     * @param answer
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setAnswer(String answer) {
        this.answer = answer;
        
        return this;
    }
    /**       
     * processed getter method
     *
     * @return processed method
     */
    public boolean isProcessed() {
        return this.processed;
    }
    
    /**       
     * processed setter method
     *
     * @param processed
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setProcessed(boolean processed) {
        this.processed = processed;
        
        return this;
    }
    /**       
     * success getter method
     *
     * @return success method
     */
    public boolean isSuccess() {
        return this.success;
    }
    
    /**       
     * success setter method
     *
     * @param success
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setSuccess(boolean success) {
        this.success = success;
        
        return this;
    }
    /**       
     * elapsedTime getter method
     *
     * @return elapsedTime method
     */
    public Long getElapsedTime() {
        return this.elapsedTime;
    }
    
    /**       
     * elapsedTime setter method
     *
     * @param elapsedTime
     *
     * @return ServerMessage modified instance
     */
    public ServerMessage setElapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
        
        return this;
    }

    /**
     * Creates a String representation of the ServerMessage object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("message").append("='").append(getMessage()).append("' ");			
        buffer.append("when").append("='").append(getWhen()).append("' ");			
        buffer.append("answer").append("='").append(getAnswer()).append("' ");			
        buffer.append("processed").append("='").append(isProcessed()).append("' ");			
        buffer.append("success").append("='").append(isSuccess()).append("' ");			
        buffer.append("elapsedTime").append("='").append(getElapsedTime()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ServerMessage object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ServerMessage other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("message".equalsIgnoreCase(attributeName))
        	this.message = attributeValue;

        if ("when".equalsIgnoreCase(attributeName))
            this.when = Timestamp.valueOf(attributeValue);

        if ("answer".equalsIgnoreCase(attributeName))
        	this.answer = attributeValue;

        if ("processed".equalsIgnoreCase(attributeName))
            this.processed = Boolean.valueOf(attributeValue);

        if ("success".equalsIgnoreCase(attributeName))
            this.success = Boolean.valueOf(attributeValue);

        if ("elapsedTime".equalsIgnoreCase(attributeName))
            this.elapsedTime = Long.valueOf(attributeValue);

    }


}
