package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IConfigurationsService;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigurationDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ConfigurationDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Configuration;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigNodeDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ConfigNodeDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ConfigSetDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IConfigServerSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ConfigServerSetDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class ConfigurationsServiceImpl implements IConfigurationsService {

	/**
	 * Obtains a new Configuration DAO
	 *
	 * @return A new IConfigurationDAO
	 */
    public IConfigurationDAO getConfigurationDAO() {
    	return new ConfigurationDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Configuration entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Configuration> getConfigurationDataSet() {
        return new HibernateDataSet<Configuration>(Configuration.class, new ConfigurationDAOImpl(),
                Configuration.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ConfigNode DAO
	 *
	 * @return A new IConfigNodeDAO
	 */
    public IConfigNodeDAO getConfigNodeDAO() {
    	return new ConfigNodeDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ConfigNode entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigNode> getConfigNodeDataSet() {
        return new HibernateDataSet<ConfigNode>(ConfigNode.class, new ConfigNodeDAOImpl(),
                ConfigNode.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ConfigSet DAO
	 *
	 * @return A new IConfigSetDAO
	 */
    public IConfigSetDAO getConfigSetDAO() {
    	return new ConfigSetDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ConfigSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigSet> getConfigSetDataSet() {
        return new HibernateDataSet<ConfigSet>(ConfigSet.class, new ConfigSetDAOImpl(),
                ConfigSet.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ConfigServerSet DAO
	 *
	 * @return A new IConfigServerSetDAO
	 */
    public IConfigServerSetDAO getConfigServerSetDAO() {
    	return new ConfigServerSetDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ConfigServerSet entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ConfigServerSet> getConfigServerSetDataSet() {
        return new HibernateDataSet<ConfigServerSet>(ConfigServerSet.class, new ConfigServerSetDAOImpl(),
                ConfigServerSet.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Configuration.class)
            return getConfigurationDataSet();

        if (clazz == ConfigNode.class)
            return getConfigNodeDataSet();

        if (clazz == ConfigSet.class)
            return getConfigSetDataSet();

        if (clazz == ConfigServerSet.class)
            return getConfigServerSetDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Configuration.class.getSimpleName()))
            return getConfigurationDataSet();

        if (entityName.equalsIgnoreCase(ConfigNode.class.getSimpleName()))
            return getConfigNodeDataSet();

        if (entityName.equalsIgnoreCase(ConfigSet.class.getSimpleName()))
            return getConfigSetDataSet();

        if (entityName.equalsIgnoreCase(ConfigServerSet.class.getSimpleName()))
            return getConfigServerSetDataSet();

        return null;
    }
}