package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IEventsService;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.EventDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventSubscriptionDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.EventSubscriptionDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventLogProcessDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.EventLogProcessDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.EventLogProcess;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class EventsServiceImpl implements IEventsService {

	/**
	 * Obtains a new Event DAO
	 *
	 * @return A new IEventDAO
	 */
    public IEventDAO getEventDAO() {
    	return new EventDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Event entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Event> getEventDataSet() {
        return new HibernateDataSet<Event>(Event.class, new EventDAOImpl(),
                Event.getPKFieldListAsString());
    }

	/**
	 * Obtains a new EventSubscription DAO
	 *
	 * @return A new IEventSubscriptionDAO
	 */
    public IEventSubscriptionDAO getEventSubscriptionDAO() {
    	return new EventSubscriptionDAOImpl();
    }

    /**
     * Obtains a new DataSet for the EventSubscription entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventSubscription> getEventSubscriptionDataSet() {
        return new HibernateDataSet<EventSubscription>(EventSubscription.class, new EventSubscriptionDAOImpl(),
                EventSubscription.getPKFieldListAsString());
    }

	/**
	 * Obtains a new EventLogProcess DAO
	 *
	 * @return A new IEventLogProcessDAO
	 */
    public IEventLogProcessDAO getEventLogProcessDAO() {
    	return new EventLogProcessDAOImpl();
    }

    /**
     * Obtains a new DataSet for the EventLogProcess entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EventLogProcess> getEventLogProcessDataSet() {
        return new HibernateDataSet<EventLogProcess>(EventLogProcess.class, new EventLogProcessDAOImpl(),
                EventLogProcess.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Event.class)
            return getEventDataSet();

        if (clazz == EventSubscription.class)
            return getEventSubscriptionDataSet();

        if (clazz == EventLogProcess.class)
            return getEventLogProcessDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Event.class.getSimpleName()))
            return getEventDataSet();

        if (entityName.equalsIgnoreCase(EventSubscription.class.getSimpleName()))
            return getEventSubscriptionDataSet();

        if (entityName.equalsIgnoreCase(EventLogProcess.class.getSimpleName()))
            return getEventLogProcessDataSet();

        return null;
    }
}