package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IServersService;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IServerDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ServerDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IServerActivityLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ServerActivityLogDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IServerMessageDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.ServerMessageDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class ServersServiceImpl implements IServersService {

	/**
	 * Obtains a new Server DAO
	 *
	 * @return A new IServerDAO
	 */
    public IServerDAO getServerDAO() {
    	return new ServerDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Server entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Server> getServerDataSet() {
        return new HibernateDataSet<Server>(Server.class, new ServerDAOImpl(),
                Server.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ServerActivityLog DAO
	 *
	 * @return A new IServerActivityLogDAO
	 */
    public IServerActivityLogDAO getServerActivityLogDAO() {
    	return new ServerActivityLogDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ServerActivityLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerActivityLog> getServerActivityLogDataSet() {
        return new HibernateDataSet<ServerActivityLog>(ServerActivityLog.class, new ServerActivityLogDAOImpl(),
                ServerActivityLog.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ServerMessage DAO
	 *
	 * @return A new IServerMessageDAO
	 */
    public IServerMessageDAO getServerMessageDAO() {
    	return new ServerMessageDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ServerMessage entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerMessage> getServerMessageDataSet() {
        return new HibernateDataSet<ServerMessage>(ServerMessage.class, new ServerMessageDAOImpl(),
                ServerMessage.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Server.class)
            return getServerDataSet();

        if (clazz == ServerActivityLog.class)
            return getServerActivityLogDataSet();

        if (clazz == ServerMessage.class)
            return getServerMessageDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Server.class.getSimpleName()))
            return getServerDataSet();

        if (entityName.equalsIgnoreCase(ServerActivityLog.class.getSimpleName()))
            return getServerActivityLogDataSet();

        if (entityName.equalsIgnoreCase(ServerMessage.class.getSimpleName()))
            return getServerMessageDataSet();

        return null;
    }
}