package pt.digitalis.dif.ecommerce;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;

/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 30, 2012
 */
public interface IECommerceBusiness
{

    /**
     * Decoded a eCommerce business identifier (that included eCommerce and business implementation identifiers,
     * extracting the original business identifier)
     *
     * @param paymentRecord the payment record
     *
     * @return the decoded business identifier (i.e.: registration number)
     */
    public String decode(EcommercePayments paymentRecord);

    /**
     * Creates a ECommerce businessID string encoding the:
     * <ul>
     * <li>eCommerceImplementation identifier (i.e.: RU - RedUnicre)</li>
     * <li>eCommerceBusinessImplementation identifier (i.e.: EVNT - GerEventos)</li>
     * <li>business identifier (i.e.: registration number)</li>
     * </ul>
     *
     * @param businessID              the business identifier (i.e.: registration number)
     * @param eCommerceImplementation the eCommerce implementation instance
     *
     * @return the encoded business ID
     */
    public String encodeBusinessId(String businessID, IECommerce<?> eCommerceImplementation);

    /**
     * Creates a ECommerce businessID string encoding the:
     * <ul>
     * <li>eCommerceImplementation identifier (i.e.: RU - RedUnicre)</li>
     * <li>eCommerceBusinessImplementation identifier (i.e.: EVNT - GerEventos)</li>
     * <li>business identifier (i.e.: registration number)</li>
     * </ul>
     *
     * @param businessID                the business identifier (i.e.: registration number)
     * @param eCommerceImplementationID the eCommerce implementation short identifier
     *
     * @return the encoded business ID
     */
    public String encodeBusinessId(String businessID, String eCommerceImplementationID);

    /**
     * @return the full business implementation identifier
     */
    public String getFullIdentifier();

    /**
     * @return the short business implementation identifier
     */
    public String getShortIdentifier();

    /**
     * Creates a new {@link PaymentRequest} instantiated with the full generated business unique identifier and Creator
     * identifier
     *
     * @param context the current dif context
     *
     * @return the instantiated {@link PaymentRequest} object binded to this business implementation
     */
    public PaymentRequest newPaymentRequest(IDIFContext context);

    /**
     * Process payment.
     *
     * @param ePaymentRecord the payment record
     *
     * @return the boolean
     */
    public BusinessProcessResult processPayment(EcommercePayments ePaymentRecord);
}
