/**
 * 2012, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.ecommerce;

import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The Class PaymentExecutionResult. This class is used internally by the AIP for transporting the result from the
 * Payment Gateway to the generic methods.
 *
 * @param <T> the provider specific response type
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 10, 2012
 */
public class PaymentExecutionResult<T> implements IObjectFormatter
{

    /** The amount. */
    protected BigDecimal amount;

    /** The authorization id. */
    protected String authorizationId;

    /** The business context. */
    protected String businessContext;

    /** The Unique transaction ID. */
    protected String id;

    /** The message. */
    protected String message;

    /** The message for user */
    protected String messageForUser;

    /** The payment Failed. */
    protected boolean paymentFailed = true;

    /** The props. */
    protected Map<String, Object> props = new HashMap<String, Object>();

    /** the provider response. */
    protected T providerResponse;

    /** The redirect url. */
    protected String redirectURL;

    /** The security token. */
    protected String securityToken;

    /** The success. */
    protected boolean success = false;

    /** The transaction date. */
    protected Date transactionDate;

    /** The transaction id. */
    protected String transactionId;

    /**
     * Adds the property.
     *
     * @param key   the key to add
     * @param value the value to add
     */

    public void addProperty(String key, Object value)
    {
        props.put(key, value);
    }

    /**
     * Gets the amount.
     *
     * @return the amount
     */
    public BigDecimal getAmmount()
    {
        return amount;
    }

    /**
     * Modifier for the 'amount' attribute.
     *
     * @param amount the new amount value to set
     */

    public void setAmmount(BigDecimal amount)
    {
        this.amount = amount;
    }

    /**
     * Inspector for the 'authorizationId' attribute.
     *
     * @return the authorizationId value
     */

    public String getAuthorizationId()
    {
        return authorizationId;
    }

    /**
     * Modifier for the 'authorizationId' attribute.
     *
     * @param authorizationId the new authorizationId value to set
     */

    public void setAuthorizationId(String authorizationId)
    {
        this.authorizationId = authorizationId;
    }

    /**
     * Inspector for the 'businessContext' attribute.
     *
     * @return the businessContext value
     */
    public String getBusinessContext()
    {
        return businessContext;
    }

    /**
     * Modifier for the 'businessContext' attribute.
     *
     * @param businessContext the new businessContext value to set
     */

    public void setBusinessContext(String businessContext)
    {
        this.businessContext = businessContext;
    }

    /**
     * Inspector for the 'message' attribute.
     *
     * @return the message value
     */
    public String getMessage()
    {
        return message;
    }

    /**
     * Modifier for the 'message' attribute.
     *
     * @param message the new message value to set
     */
    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * @return the messageForUser
     */
    public String getMessageForUser()
    {
        return messageForUser;
    }

    /**
     * @param messageForUser the messageForUser to set
     */
    public void setMessageForUser(String messageForUser)
    {
        this.messageForUser = messageForUser;
    }

    /**
     * Inspector for the 'props' attribute.
     *
     * @return the props value
     */

    public Map<String, Object> getProps()
    {
        return props;
    }

    /**
     * Inspector for the 'providerResponse' attribute.
     *
     * @return the providerResponse value
     */

    public T getProviderResponse()
    {
        return providerResponse;
    }

    /**
     * Modifier for the 'providerResponse' attribute.
     *
     * @param providerResponse the new providerResponse value to set
     */

    public void setProviderResponse(T providerResponse)
    {
        this.providerResponse = providerResponse;
    }

    /**
     * Inspector for the 'redirectURL' attribute.
     *
     * @return the redirectURL value
     */

    public String getRedirectURL()
    {
        return redirectURL;
    }

    /**
     * Modifier for the 'redirectURL' attribute.
     *
     * @param redirectURL the new redirectURL value to set
     */

    public void setRedirectURL(String redirectURL)
    {
        this.redirectURL = redirectURL;
    }

    /**
     * Inspector for the 'securityToken' attribute.
     *
     * @return the securityToken value
     */

    public String getSecurityToken()
    {
        return securityToken;
    }

    /**
     * Modifier for the 'securityToken' attribute.
     *
     * @param securityToken the new securityToken value to set
     */

    public void setSecurityToken(String securityToken)
    {
        this.securityToken = securityToken;
    }

    /**
     * Inspector for the 'transactionDate' attribute.
     *
     * @return the transactionDate value
     */

    public Date getTransactionDate()
    {
        return transactionDate;
    }

    /**
     * Modifier for the 'transactionDate' attribute.
     *
     * @param transactionDate the new transactionDate value to set
     */

    public void setTransactionDate(Date transactionDate)
    {
        this.transactionDate = transactionDate;
    }

    /**
     * Inspector for the 'transactionId' attribute.
     *
     * @return the transactionId value
     */

    public String getTransactionId()
    {
        return transactionId;
    }

    /**
     * Modifier for the 'transactionId' attribute.
     *
     * @param transactionId the new transactionId value to set
     */

    public void setTransactionId(String transactionId)
    {
        this.transactionId = transactionId;
    }

    /**
     * Inspector for the 'paymentFailed' attribute.
     *
     * @return the paymentFailed value
     */
    public boolean isPaymentFailed()
    {
        return paymentFailed;
    }

    /**
     * Modifier for the 'paymentFailed' attribute.
     *
     * @param paymentFailed the new paymentFailed value to set
     */
    public void setPaymentFailed(boolean paymentFailed)
    {
        this.paymentFailed = paymentFailed;
    }

    /**
     * Inspector for the 'success' attribute.
     *
     * @return the success value
     */
    public boolean isSuccess()
    {
        return success;
    }

    /**
     * Modifier for the 'success' attribute.
     *
     * @param success the new success value to set
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    }

    /**
     * Modifier for the 'id' attribute.
     *
     * @param id the new id value to set
     */

    public void setId(String id)
    {
        this.id = id;
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("id", id);
        formatter.addItem("businessContext", businessContext);
        formatter.addItem("amount", amount);
        formatter.addItem("message", message);
        formatter.addItem("securityToken", securityToken);
        formatter.addItem("providerResponse", providerResponse);
        formatter.addItem("authorizationId", authorizationId);
        formatter.addItem("redirectURL", redirectURL);
        formatter.addItem("transactionDate", transactionDate);
        formatter.addItem("transactionId", transactionId);
        formatter.addItem("props", props);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
