/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.users.preferences;

import pt.digitalis.dif.controller.security.managers.IUserPreferencesManager;
import pt.digitalis.dif.dem.managers.impl.model.IUserPreferencesService;
import pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.IConfigurations;

import java.util.List;

/**
 * The Class UserPreferencesManagerDBImpl.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 12/03/2019
 */
public class UserPreferencesManagerDBImpl implements IUserPreferencesManager
{

    /** The user preferences service. */
    static IUserPreferencesService userPreferencesService =
            DIFIoCRegistry.getRegistry().getImplementation(IUserPreferencesService.class);

    /** The config ID. */
    private static String configID = null;

    /**
     * Inspector for the 'configID' attribute.
     *
     * @return the configID value
     */
    public static String getConfigID()
    {
        if (configID == null)
        {
            IConfigurations configs = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
            configID = configs.getGeneralPrefix();
        }

        return configID;
    }

    /**
     * Gets the user preferences.
     *
     * @param userID the user ID
     *
     * @return the user preferences
     *
     * @exception InternalFrameworkException the internal framework exception
     * @see pt.digitalis.dif.controller.security.managers.IUserPreferencesManager#getUserPreferences(java.lang.String)
     */
    @Override
    public CaseInsensitiveHashMap<Object> getUserPreferences(String userID) throws InternalFrameworkException
    {
        CaseInsensitiveHashMap<Object> result = new CaseInsensitiveHashMap<Object>();

        try
        {
            Query<UserPreferences> query = userPreferencesService.getUserPreferencesDataSet().query();
            query.equals(UserPreferences.FK().CONFIGID(), getConfigID());
            query.equals(UserPreferences.FK().USERID(), userID);

            List<UserPreferences> list = query.asList();

            for (UserPreferences userPref : list)
            {
                result.put(userPref.getAttributeKey(), userPref.getAttributeValue());
            }
        }
        catch (DataSetException e)
        {
            throw new InternalFrameworkException(e, null);
        }

        return result;
    }

    /**
     * Sets the user preferences.
     *
     * @param userID         the user ID
     * @param key            the key
     * @param parameterValue the parameter value
     *
     * @exception InternalFrameworkException the internal framework exception
     * @see pt.digitalis.dif.controller.security.managers.IUserPreferencesManager#setUserPreferences(java.lang.String,
     *         java.lang.String, java.lang.Object)
     */
    @Override
    public void setUserPreferences(String userID, String key, Object parameterValue) throws InternalFrameworkException
    {
        try
        {
            Query<UserPreferences> query = userPreferencesService.getUserPreferencesDataSet().query();
            query.equals(UserPreferences.FK().CONFIGID(), getConfigID());
            query.equals(UserPreferences.FK().USERID(), userID);
            query.equals(UserPreferences.FK().ATTRIBUTEKEY(), key);
            UserPreferences userPref = query.singleValue();

            if (userPref == null)
            {
                userPref = new UserPreferences();
                userPref.setConfigId(getConfigID());
                userPref.setUserId(userID);
                userPref.setAttributeKey(key);
                userPref.setAttributeValue(StringUtils.toStringOrNull(parameterValue));

                userPreferencesService.getUserPreferencesDataSet().insert(userPref);
            }
            else
            {
                userPref.setAttributeValue(StringUtils.toStringOrNull(parameterValue));
                userPreferencesService.getUserPreferencesDataSet().update(userPref);
            }
        }
        catch (DataSetException e)
        {
            throw new InternalFrameworkException(e, null);
        }
    }
}
