DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'BUSINESS_ID'
	AND IS_NULLABLE = 'NO';
	
	IF TOTAL > 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` CHANGE COLUMN `BUSINESS_ID` `BUSINESS_ID` VARCHAR(255) COMMENT 'Business UID that identifies this consent within the configuration';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
