DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'STAGE_ID';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` ADD COLUMN `STAGE_ID` VARCHAR(500) COMMENT 'Stage ID for complex consent details';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'IS_GLOBAL';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` ADD COLUMN `IS_GLOBAL` TINYINT(1) COMMENT 'Is global consent. Managed globally. If false will not be requested centrally.';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.DATA_CONSENT SET IS_GLOBAL = 1 WHERE IS_GLOBAL IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'IS_GLOBAL'
	AND IS_NULLABLE = 'NO';
	
	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` CHANGE COLUMN `IS_GLOBAL` `IS_GLOBAL` TINYINT(1) NOT NULL COMMENT 'Is global consent. Managed globally. If false will not be requested centrally.' ;
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'IS_ANSWERED_WHEN_DISABLED';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` ADD COLUMN `IS_ANSWERED_WHEN_DISABLED` TINYINT(1) COMMENT 'Is considered anwsered when the consent is disabled.';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.DATA_CONSENT SET IS_ANSWERED_WHEN_DISABLED = 0 WHERE IS_ANSWERED_WHEN_DISABLED IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'DATA_CONSENT' 
	AND COLUMN_NAME = 'IS_ANSWERED_WHEN_DISABLED'
	AND IS_NULLABLE = 'NO';
	
	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`DATA_CONSENT` CHANGE COLUMN `IS_ANSWERED_WHEN_DISABLED` `IS_ANSWERED_WHEN_DISABLED` TINYINT(1) NOT NULL;
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'USER_DATA_CONSENT' 
	AND COLUMN_NAME = 'DETAILS';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`USER_DATA_CONSENT` ADD COLUMN `DETAILS` LONGTEXT COMMENT 'Details in JSON format of the consent given (when there is more than a simples yes or no)';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$
