DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'AREA' 
  AND COLUMN_NAME = 'IS_VISIBLE';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`AREA` ADD COLUMN `IS_VISIBLE` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.AREA SET IS_VISIBLE = 1 WHERE IS_VISIBLE IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'AREA' 
  AND COLUMN_NAME = 'IS_VISIBLE'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`AREA` CHANGE COLUMN `IS_VISIBLE` `IS_VISIBLE` TINYINT(1) NOT NULL COMMENT 'If the indicator is visible.';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
