-----------------------------------------------------------------------------------------------------------------------
--- TABLE JASPER_REPORT_CONFIG table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.JASPER_REPORT_CONFIG
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  TEMPLATE_ID            INT NOT NULL COMMENT 'Jasper Report Template ID',
  BUSINESS_ID            VARCHAR(255) COMMENT 'The business ID that somehow links this configuration to is business use',
  PARAMETERS_VALUES      LONGTEXT     COMMENT 'The parameter values in JSON format',
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_JASPER_CONFIG_TEMP` FOREIGN KEY (`TEMPLATE_ID`) REFERENCES `JASPER_REPORT_TEMPLATE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  INDEX `JASPER_REPORT_CONFIG_ID_IDX` (`TEMPLATE_ID`,`BUSINESS_ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- JASPER_REPORT_LOG table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.JASPER_REPORT_LOG
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  TEMPLATE_ID            INT NOT NULL COMMENT 'The template the log belongs to',
  BUSINESS_ID            VARCHAR(255) COMMENT 'The business ID that somehow links this configuration to is business use',
  PARAMETERS_VALUES      LONGTEXT     COMMENT 'The parameter values in JSON format',
  USER_ID                VARCHAR(255) COMMENT 'The user ID',
  LOG_DATE               TIMESTAMP  NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'The execution date',
  EXECUTION_TIME         INT NOT NULL COMMENT 'The execution elapsed time',
  DOCUMENT_ID            INT NOT NULL COMMENT 'The document in the document repository ID',
  PRIMARY KEY (`ID`), 
  KEY `JASPER_REPT_TEMP_FILE_PK` (`ID`),
  CONSTRAINT `FK_JASPER_LOG_TEMPLATE` FOREIGN KEY (`TEMPLATE_ID`) REFERENCES `JASPER_REPORT_TEMPLATE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  INDEX `JASPER_REPORT_LOG_TEMPLATE_IDX` (`TEMPLATE_ID`,`LOG_DATE`),
  INDEX `JASPER_REPORT_LOG_BID_IDX` (`BUSINESS_ID`,`LOG_DATE`),
  INDEX `JASPER_REPORT_LOG_DATE_IDX` (`LOG_DATE`,`TEMPLATE_ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'JASPER_REPORT_TEMPLATE' 
  AND COLUMN_NAME = 'LOG_EXECUTION';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`JASPER_REPORT_TEMPLATE` ADD COLUMN `LOG_EXECUTION` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.JASPER_REPORT_TEMPLATE SET LOG_EXECUTION = 1 WHERE LOG_EXECUTION IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'JASPER_REPORT_TEMPLATE' 
  AND COLUMN_NAME = 'LOG_EXECUTION'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`JASPER_REPORT_TEMPLATE` CHANGE COLUMN `LOG_EXECUTION` `LOG_EXECUTION` TINYINT(1) NOT NULL COMMENT 'If the report executions should be logged.';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$


DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'JASPER_REPORT_TEMPLATE' 
  AND COLUMN_NAME = 'LOG_FILE_RESULT';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`JASPER_REPORT_TEMPLATE` ADD COLUMN `LOG_FILE_RESULT` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.JASPER_REPORT_TEMPLATE SET LOG_FILE_RESULT = 1 WHERE LOG_FILE_RESULT IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'JASPER_REPORT_TEMPLATE' 
  AND COLUMN_NAME = 'LOG_FILE_RESULT'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`JASPER_REPORT_TEMPLATE` CHANGE COLUMN `LOG_FILE_RESULT` `LOG_FILE_RESULT` TINYINT(1) NOT NULL COMMENT 'If the report file output should be logged.';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
