DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'ACL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.ACL( '||
      '  ID            NUMBER(10) NOT NULL, '||
      '  USER_ID       VARCHAR2(255), '||
      '  GROUP_ID    VARCHAR2(255), '||
      '  ENTITY_TYPE   VARCHAR2(255), '||
      '  ENTITY_ID     VARCHAR2(255), '||
      '  PUBLIC_ACCESS VARCHAR2(1), '||
      '  IS_ENABLED   VARCHAR2(1), '||
      '  IS_DEFAULT    VARCHAR2(1)   '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'ACL'
  AND    CONSTRAINT_NAME = 'ACL_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.ACL ADD CONSTRAINT ACL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_ACL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_ACL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CUSTOM_MESSAGES';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CUSTOM_MESSAGES( '||
      '  MESSAGE_ID VARCHAR2(4000) NOT NULL,  '||
      '  MESSAGE VARCHAR2(4000) NOT NULL,  '||
      '  ENTITY_ID VARCHAR2(4000) NOT NULL,  '||
      '  ID NUMBER NOT NULL,  '||
      '  LANGUAGE VARCHAR2(4000),  '||
      '  CONSTRAINT ID PRIMARY KEY (ID) '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CUSTOM_MESSAGES';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.CUSTOM_MESSAGES( '||
      '  MESSAGE_ID VARCHAR2(4000) NOT NULL,  '||
      '  MESSAGE VARCHAR2(4000) NOT NULL,  '||
      '  ENTITY_ID VARCHAR2(4000) NOT NULL,  '||
      '  ID NUMBER NOT NULL,  '||
      '  LANGUAGE VARCHAR2(4000),  '||
      '  CONSTRAINT ID PRIMARY KEY (ID) '||
      ') ';
  END IF;
END;
/

ALTER TABLE dif.custom_messages MODIFY ( id DEFAULT 0 );


COMMENT ON COLUMN dif.custom_messages.message_id IS 'O identificador da mensagem na pagina.';


COMMENT ON COLUMN dif.custom_messages.message IS 'O valor da mensagem.';


COMMENT ON COLUMN dif.custom_messages.entity_id IS 'ID da entidade a qual pertence a mensagem. Tem a forma: tipo_da_entidade:nome_da_entidade. Ex.: STAGE:homestage.';


COMMENT ON COLUMN dif.custom_messages.id IS 'PK';


COMMENT ON COLUMN dif.custom_messages.language IS 'lingua';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'PERSISTENT_ACTION';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.PERSISTENT_ACTION( '||
    '  ID            NUMBER NOT NULL,' ||
    '  OBJECT_ACTION BLOB NOT NULL,' ||
    '  POOL_NAME     VARCHAR2(1000),' ||
    '  ACTION_ID     NUMBER ' ||
    ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'PERSISTENCE_POOL_ACTION_ID';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.PERSISTENCE_POOL_ACTION_ID MINVALUE 1 MAXVALUE 9999999999999999999999999999 START WITH 1 INCREMENT BY 1 CACHE 20';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER DIF.ACTION_BFR_INS
BEFORE INSERT ON DIF.PERSISTENT_ACTION
FOR EACH ROW
BEGIN
  IF :NEW.ID IS NULL THEN
     SELECT DIF.PERSISTENCE_POOL_ACTION_ID.NEXTVAL INTO :NEW.ID
     FROM DUAL;
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'PERSISTENCE_POOL'
  AND    TABLE_NAME = 'PERSISTENT_ACTION';

  IF TOTAL > 0 THEN

    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS
    WHERE  OWNER      = 'PERSISTENCE_POOL'
    AND    TABLE_NAME = 'PERSISTENT_ACTION'
    AND    COLUMN_NAME = 'COPIED_NEW_SCHEMA';

    IF TOTAL = 0 THEN
      EXECUTE IMMEDIATE 'ALTER TABLE PERSISTENCE_POOL.PERSISTENT_ACTION ADD COPIED_NEW_SCHEMA NUMBER DEFAULT 0';
    END IF;

    EXECUTE IMMEDIATE
    ' BEGIN ' ||
        ' FOR R IN (SELECT * FROM PERSISTENCE_POOL.PERSISTENT_ACTION WHERE COPIED_NEW_SCHEMA = 0) LOOP ' ||
          ' INSERT INTO DIF.PERSISTENT_ACTION(OBJECT_ACTION,POOL_NAME,ACTION_ID) ' ||
          ' VALUES( R.OBJECT_ACTION, R.POOL_NAME, R.ACTION_ID);' ||
        ' END LOOP;' ||
        'UPDATE PERSISTENCE_POOL.PERSISTENT_ACTION SET COPIED_NEW_SCHEMA = 1;' ||
    ' END;';
    COMMIT;
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'PERSISTENT_ACTION'
  AND    CONSTRAINT_NAME = 'PERSISTENT_ACTION_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.PERSISTENT_ACTION ADD CONSTRAINT PERSISTENT_ACTION_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'PERSISTENT_ACTION'
  AND    CONSTRAINT_NAME = 'ACTION_ID_POOL_NAME';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.PERSISTENT_ACTION ADD CONSTRAINT ACTION_ID_POOL_NAME UNIQUE (POOL_NAME, ACTION_ID)';
  END IF;
END;
/

COMMENT ON COLUMN DIF.PERSISTENT_ACTION.ID IS 'O IDENTIFICADOR UNICO DA ACTION NA BD';

COMMENT ON COLUMN DIF.PERSISTENT_ACTION.OBJECT_ACTION IS 'O OBJECTO ACTION SERIALIZED';

COMMENT ON COLUMN DIF.PERSISTENT_ACTION.POOL_NAME IS 'O NOME UNICO DA POOL QUE CRIOU A ACTION';

COMMENT ON COLUMN DIF.PERSISTENT_ACTION.ACTION_ID IS 'ACTION INTERNAL ID';


/* ## CRIAO DA TABELA DIF.T_ECOMMERCE_PAYMENTS ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'T_ECOMMERCE_PAYMENTS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      '(ID                  NUMBER '||
                      ',BUSINESS_ID         VARCHAR2(50) '||
                      ',TRANSACTION_ID      VARCHAR2(100) '||
                      ',CREATOR             VARCHAR2(50) '||
                      ',BUSINESS_CONTEXT    VARCHAR2(4000) '||
                      ',ECOMMERCE_PROCESSOR VARCHAR2(50) '||
                      ',PAYMENT_VALUE       NUMBER '||
                      ',STATUS              VARCHAR2(1) '||
                      ',STATUS_MESSAGE      VARCHAR2(4000) '||
                      ',SECURITY_TOKEN      VARCHAR2(1000) '||
                      ',DATE_CREATION       DATE '||
                      ',DATE_RECEIVED       DATE '||
                      ',DATE_PROCESSED      DATE '||
                      ',TRANSACTION_DATE    DATE '||
                      ',AUTHORIZATION_ID VARCHAR2(20) ' ||
                      ',REDIRECT_URL VARCHAR2(4000) ' ||
                      ',CONFIGURATION_ID VARCHAR2(100) ' ||
                      ',REGISTER_ID         NUMBER) '||
                      'TABLESPACE MEDIUM '||
                      'STORAGE (INITIAL 256K NEXT 504K MINEXTENTS 1 MAXEXTENTS 505 PCTINCREASE 10)';
  END IF;
END;
/

COMMENT ON COLUMN DIF.T_ECOMMERCE_PAYMENTS.CONFIGURATION_ID IS 'Identificador da configurao utilizada para inicializar o pagamento';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SYNONYMS
  WHERE  SYNONYM_NAME = 'ECOMMERCE_PAYMENTS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE PUBLIC SYNONYM ECOMMERCE_PAYMENTS FOR DIF.T_ECOMMERCE_PAYMENTS';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_PK '||
                      'PRIMARY KEY (ID) '||
                      'USING INDEX TABLESPACE INDX '||
                      'STORAGE (INITIAL 250K NEXT 200K PCTINCREASE 20)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_ID_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_ID_NN '||
                      'CHECK ("ID" IS NOT NULL)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_BUSINESS_ID_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_BUSINESS_ID_NN '||
                      'CHECK ("BUSINESS_ID" IS NOT NULL)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_CREATOR_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_CREATOR_NN '||
                      'CHECK ("CREATOR" IS NOT NULL)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_ECOM_PROCESSOR_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_ECOM_PROCESSOR_NN '||
                      'CHECK ("ECOMMERCE_PROCESSOR" IS NOT NULL)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_STATUS_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_STATUS_NN '||
                      'CHECK ("STATUS" IS NOT NULL)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_STATUS_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_STATUS_CK '||
                      'CHECK ("STATUS" IN (''W'',''R'',''P'',''F''))';
    /*
       Valores possveis:
       W - Waiting
       R - Recieved
       P - Processed
       F - Failed
    */
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_DATE_CREATION_NN';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_DATE_CREATION_NN '||
                      'CHECK ("DATE_CREATION" IS NOT NULL)';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER DIF.TRG_ECOMMERCE_PAYMENTS_BEF_INS
BEFORE INSERT ON DIF.T_ECOMMERCE_PAYMENTS
FOR EACH ROW
DECLARE
  NID NUMBER;
BEGIN
  IF :NEW.ID IS NULL THEN
    SELECT SEQ_ECOMPAYMENTS_ID.NEXTVAL
    INTO   NID
    FROM   DUAL;

    :NEW.ID := NID;
  END IF;
END TRG_ECOMMERCE_PAYMENTS_BEF_INS;
/

/* ## CRIAO DA SEQUNCIA DIF.ECOMMERCE_PAYMENT_ID_SEQ ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER = 'DIF'
  AND    SEQUENCE_NAME  = 'ECOMMERCE_PAYMENT_ID_SEQ';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.ECOMMERCE_PAYMENT_ID_SEQ START WITH 1 INCREMENT BY 1 MAXVALUE 9999999999999999999999999999 NOCACHE';
  END IF;
END;
/

/* ## ALTERAO DA TABELA DIF.T_ECOMMERCE_PAYMENTS ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'T_ECOMMERCE_PAYMENTS'
  AND    INDEX_NAME = 'ECOMPAYMENTS_TOKEN_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.ECOMPAYMENTS_TOKEN_IDX '||
                      'ON DIF.T_ECOMMERCE_PAYMENTS (SECURITY_TOKEN) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'T_ECOMMERCE_PAYMENTS'
  AND    INDEX_NAME = 'ECOMPAYMENTS_STATUS_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.ECOMPAYMENTS_STATUS_IDX '||
                      'ON DIF.T_ECOMMERCE_PAYMENTS (STATUS, DATE_CREATION) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

/* ## ALTERAO DA TABELA DIF.T_ECOMMERCE_PAYMENTS ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'T_ECOMMERCE_PAYMENTS'
  AND    CONSTRAINT_NAME = 'ECOMPAYMENTS_BUSINESS_ID_UK';

  IF TOTAL = 0 THEN
    SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_INDEXES
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'T_ECOMMERCE_PAYMENTS'
    AND    INDEX_NAME = 'ECOMPAYMENTS_BUSINESS_ID_IDX';

    IF TOTAL > 0 THEN
      EXECUTE IMMEDIATE 'DROP INDEX DIF.ECOMPAYMENTS_BUSINESS_ID_IDX';
    END IF;

    EXECUTE IMMEDIATE 'ALTER TABLE DIF.T_ECOMMERCE_PAYMENTS '||
                      'ADD CONSTRAINT ECOMPAYMENTS_BUSINESS_ID_UK '||
                      'UNIQUE (BUSINESS_ID) '||
                      'USING INDEX TABLESPACE INDX '||
                      'STORAGE (INITIAL 250K NEXT 200K PCTINCREASE 20)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'GROUPS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.GROUPS ' ||
						'( ' ||
						'  ID             VARCHAR2(200) NOT NULL, ' ||
						'  NAME           VARCHAR2(200) NOT NULL, ' ||
						'  DESCRIPTION    VARCHAR2(500), ' ||
						'  PARENT_GROUPID VARCHAR2(200), ' ||
						'  DEFAULT_GROUP  NUMBER(1) NOT NULL ' ||
						')';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'GROUPS'
  AND    CONSTRAINT_NAME = 'GROUPS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.GROUPS ADD CONSTRAINT GROUPS_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'GROUPS'
  AND    CONSTRAINT_NAME = 'FK_GROUPS_GROUPS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.GROUPS ADD CONSTRAINT FK_GROUPS_GROUPS FOREIGN KEY (PARENT_GROUPID) REFERENCES DIF.GROUPS (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USERS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	
		'CREATE TABLE DIF.USERS ' ||
		'( ' ||
		'  ID           VARCHAR2(200) NOT NULL, ' ||
		'  PROFILEID    VARCHAR2(200), ' ||
		'  EMAIL        VARCHAR2(45), ' ||
		'  ENABLED      NUMBER(1) NOT NULL, ' ||
		'  NAME         VARCHAR2(500), ' ||
		'  PASSWORD     VARCHAR2(200) NOT NULL, ' ||
		'  DEFAULT_USER NUMBER(1) NOT NULL, ' ||
		'  NICK         VARCHAR2(45) ' ||
		') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USERS'
  AND    CONSTRAINT_NAME = 'USERS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USERS ADD CONSTRAINT USERS_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USERS'
  AND    CONSTRAINT_NAME = 'FK_USERS_GROUPS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USERS ADD CONSTRAINT FK_USERS_GROUPS FOREIGN KEY (PROFILEID) REFERENCES DIF.GROUPS (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_GROUPS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	
		'CREATE TABLE DIF.USER_GROUPS ' ||
		'( ' ||
		'  ID      NUMBER(9) NOT NULL, ' ||
		'  USERID  VARCHAR2(200), ' ||
		'  GROUPID VARCHAR2(200) ' ||
		')';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_GROUPS'
  AND    CONSTRAINT_NAME = 'USER_GROUPS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_GROUPS ADD CONSTRAINT USER_GROUPS_PK PRIMARY KEY (ID)';
  END IF;
END;
/
 
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_GROUPS'
  AND    CONSTRAINT_NAME = 'USER_GROUPS_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_GROUPS ADD CONSTRAINT USER_GROUPS_UK UNIQUE (USERID, GROUPID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_GROUPS'
  AND    CONSTRAINT_NAME = 'FK_USER_GROUPS_GROUPS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_GROUPS ADD CONSTRAINT FK_USER_GROUPS_GROUPS FOREIGN KEY (GROUPID) REFERENCES DIF.GROUPS (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_GROUPS'
  AND    CONSTRAINT_NAME = 'FK_USER_GROUPS_USERS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_GROUPS ADD CONSTRAINT FK_USER_GROUPS_USERS FOREIGN KEY (USERID) REFERENCES DIF.USERS (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_ATTRIBUTES';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	
		'CREATE TABLE DIF.USER_ATTRIBUTES ' ||
		'( ' ||
		'  ID              NUMBER(9) NOT NULL, ' ||
		'  USERID          VARCHAR2(200) NOT NULL, ' ||
		'  ATTRIBUTE_KEY   VARCHAR2(200) NOT NULL, ' ||
		'  ATTRIBUTE_VALUE VARCHAR2(2000) ' ||
		')';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_ATTRIBUTES'
  AND    CONSTRAINT_NAME = 'USER_ATTRIBUTES_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_ATTRIBUTES ADD CONSTRAINT USER_ATTRIBUTES_PK PRIMARY KEY (ID)';
  END IF;
END;
/
 
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_ATTRIBUTES'
  AND    CONSTRAINT_NAME = 'USER_ATTRIBUTES_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_ATTRIBUTES ADD CONSTRAINT USER_ATTRIBUTES_UK UNIQUE (USERID, ATTRIBUTE_KEY)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_ATTRIBUTES'
  AND    CONSTRAINT_NAME = 'FK_USER_ATTRIBUTES_USERS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_ATTRIBUTES ADD CONSTRAINT FK_USER_ATTRIBUTES_USERS FOREIGN KEY (USERID) REFERENCES DIF.USERS (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'USER_ATTRIBS_ID';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.USER_ATTRIBS_ID MINVALUE 1 MAXVALUE 999999999999999999999999999 START WITH 1 INCREMENT BY 1 NOCACHE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'USER_GROUPS_ID';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.USER_GROUPS_ID MINVALUE 1 MAXVALUE 999999999999999999999999999 START WITH 1 INCREMENT BY 1 NOCACHE';
  END IF;
END;
/



