-----------------------------------------------------------------------------------------------------------------------
--- SERVER table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'SERVER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.SERVER( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  NAME                   VARCHAR(500) NOT NULL, '||
      '  MACHINE_SERVER_UID     VARCHAR(200) NOT NULL, '||
      '  IP_ADDRESS             VARCHAR(100) NOT NULL, '||
      '  CONTEXT_ROOT           VARCHAR(100) NOT NULL, '||
      '  PORT                   VARCHAR(10) NOT NULL, '||
      '  ENDPOINT_BASE_URL      VARCHAR(500) NOT NULL, '||
      '  BOOT_TIME              DATE NOT NULL, '||
      '  LAST_SYNC              DATE NOT NULL, '||
      '  ACTIVE                 NUMBER(1), '||
      '  MISSING                NUMBER(1) '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.SERVER.ID IS 'ID';
COMMENT ON COLUMN dif.SERVER.NAME IS 'The server name';
COMMENT ON COLUMN dif.SERVER.MACHINE_SERVER_UID IS 'The machine server UID';
COMMENT ON COLUMN dif.SERVER.IP_ADDRESS IS 'The IP address';
COMMENT ON COLUMN dif.SERVER.CONTEXT_ROOT IS 'The app context root';
COMMENT ON COLUMN dif.SERVER.PORT IS 'The server HTTP port';
COMMENT ON COLUMN dif.SERVER.ENDPOINT_BASE_URL IS 'The server HTTP base URL';
COMMENT ON COLUMN dif.SERVER.BOOT_TIME IS 'Server startup time stamp';
COMMENT ON COLUMN dif.SERVER.LAST_SYNC IS 'Last sync done by the server';
COMMENT ON COLUMN dif.SERVER.ACTIVE IS 'If the server is active';
COMMENT ON COLUMN dif.SERVER.MISSING IS 'If the server is missing (too long since keep alive sync)';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER'
  AND    CONSTRAINT_NAME = 'SERVER_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER ADD CONSTRAINT SERVER_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_SERVER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_SERVER MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/


-----------------------------------------------------------------------------------------------------------------------
--- SERVER_ACTIVITY_LOG table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'SERVER_ACTIVITY_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.SERVER_ACTIVITY_LOG( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  SERVER_ID              NUMBER(10) NOT NULL, '||
      '  BOOT_TIME              DATE NOT NULL, '||
      '  LAST_SYNC              DATE NOT NULL '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.SERVER_ACTIVITY_LOG.ID IS 'ID';
COMMENT ON COLUMN dif.SERVER_ACTIVITY_LOG.SERVER_ID IS 'The server ID';
COMMENT ON COLUMN dif.SERVER_ACTIVITY_LOG.BOOT_TIME IS 'Server startup time stamp';
COMMENT ON COLUMN dif.SERVER_ACTIVITY_LOG.LAST_SYNC IS 'Last sync done by the server';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER_ACTIVITY_LOG'
  AND    CONSTRAINT_NAME = 'SERVER_ACTIVITY_LOG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER_ACTIVITY_LOG ADD CONSTRAINT SERVER_ACTIVITY_LOG_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_SERVER_ACTIVITY_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_SERVER_ACTIVITY_LOG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER_ACTIVITY_LOG'
  AND    CONSTRAINT_NAME = 'FK_SERVER_ACT_LOG_SERVER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER_ACTIVITY_LOG ADD CONSTRAINT FK_SERVER_ACT_LOG_SERVER FOREIGN KEY (SERVER_ID) REFERENCES DIF.SERVER (ID)';
  END IF;
END;
/


-----------------------------------------------------------------------------------------------------------------------
--- SERVER_MESSAGE table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'SERVER_MESSAGE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.SERVER_MESSAGE( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  SERVER_SENDER_ID       NUMBER(10) NOT NULL, '||
      '  SERVER_RECEIVER_ID     NUMBER(10) NOT NULL, '||
      '  MESSAGE                VARCHAR(4000) NOT NULL, '||
      '  WHEN                   DATE NOT NULL, '||
      '  ANSWER                 VARCHAR(4000), '||
      '  PROCESSED              NUMBER(1) NOT NULL, '||
      '  SUCCESS                NUMBER(1) NOT NULL, '||
      '  ELAPSED_TIME           NUMBER '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.SERVER_MESSAGE.ID IS 'ID';
COMMENT ON COLUMN dif.SERVER_MESSAGE.SERVER_SENDER_ID IS 'The sender server ID';
COMMENT ON COLUMN dif.SERVER_MESSAGE.SERVER_RECEIVER_ID IS 'The receiver server ID';
COMMENT ON COLUMN dif.SERVER_MESSAGE.MESSAGE IS 'Message sent';
COMMENT ON COLUMN dif.SERVER_MESSAGE.WHEN IS 'Message time stamp';
COMMENT ON COLUMN dif.SERVER_MESSAGE.ANSWER IS 'Answer received';
COMMENT ON COLUMN dif.SERVER_MESSAGE.PROCESSED IS 'If the message was processed by the receiver';
COMMENT ON COLUMN dif.SERVER_MESSAGE.SUCCESS IS 'If the message was successfully executed';
COMMENT ON COLUMN dif.SERVER_MESSAGE.ELAPSED_TIME IS 'Time elapsed to get an answer';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER_MESSAGE'
  AND    CONSTRAINT_NAME = 'SERVER_MESSAGE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER_MESSAGE ADD CONSTRAINT SERVER_MESSAGE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_SERVER_MESSAGE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_SERVER_MESSAGE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER_MESSAGE'
  AND    CONSTRAINT_NAME = 'FK_SRV_MSG_SENDER_SRV';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER_MESSAGE ADD CONSTRAINT FK_SRV_MSG_SENDER_SRV FOREIGN KEY (SERVER_SENDER_ID) REFERENCES DIF.SERVER (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERVER_MESSAGE'
  AND    CONSTRAINT_NAME = 'FK_SRV_MSG_RECEIVER_SRV';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERVER_MESSAGE ADD CONSTRAINT FK_SRV_MSG_RECEIVER_SRV FOREIGN KEY (SERVER_RECEIVER_ID) REFERENCES DIF.SERVER (ID)';
  END IF;
END;
/
