DECLARE 
  SAVISOS                   VARCHAR2(4000) := NULL;
  NTOTAL_VALORES_DIFERENTES NUMBER;
  SKEY                      VARCHAR2(500);
BEGIN


  FOR R IN (  SELECT P.CONFIG_SET_ID, P.NODE_PATH
              FROM DIF.CONFIG_NODE P
              GROUP BY P.CONFIG_SET_ID, P.NODE_PATH
              HAVING COUNT(*) > 1 ) LOOP
      
      BEGIN
        SELECT COUNT(*) , MAX(KEY)
        INTO NTOTAL_VALORES_DIFERENTES, SKEY
        FROM (
          SELECT COUNT(DISTINCT NVL(VALUE,-1111111111111111)) TOTAL_VALORES_DIFERENTES,
                 C.KEY
          FROM DIF.CONFIG_NODE CN
          INNER JOIN DIF.CONFIGURATION C ON C.CONFIG_NODE_ID = CN.ID
          WHERE CN.CONFIG_SET_ID = R.CONFIG_SET_ID
          AND   CN.NODE_PATH = R.NODE_PATH
          GROUP BY CN.CONFIG_SET_ID, CN.NODE_PATH,C.KEY
          HAVING COUNT(DISTINCT NVL(VALUE,-1111111111111111)) > 1);
          
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          NTOTAL_VALORES_DIFERENTES := 0;
      END;
      
      IF NTOTAL_VALORES_DIFERENTES > 1 THEN
        SAVISOS := SAVISOS || CHR(13)||CHR(10) || 
                    'SELECT C.*, C.ROWID ' ||
                    '  FROM DIF.CONFIGURATION C ' ||
                    ' WHERE C.KEY = '''|| SKEY || '''' ||
                    '   AND (C.CONFIG_NODE_ID) IN ' ||
                    '       (SELECT ID ' ||
                    '          FROM DIF.CONFIG_NODE CN ' ||
                    '         WHERE CONFIG_SET_ID = '|| R.CONFIG_SET_ID || 
                    '           AND NODE_PATH = '''|| R.NODE_PATH || ''')';

                   

      ELSE

        DELETE FROM DIF.CONFIG_NODE C1
        WHERE C1.CONFIG_SET_ID = R.CONFIG_SET_ID
        AND   C1.NODE_PATH     = R.NODE_PATH
        AND C1.ROWID            > (  SELECT MIN(ROWID)
                                     FROM DIF.CONFIG_NODE C2
                                     WHERE C1.CONFIG_SET_ID = C2.CONFIG_SET_ID
                                     AND C1.NODE_PATH = C2.NODE_PATH );
      END IF;      
  END LOOP;


  FOR R IN ( SELECT P.CONFIG_NODE_ID, 
                    P.KEY , 
                    COUNT(*) TOTAL, 
                    COUNT(DISTINCT NVL(VALUE,'-1111111111111111')) TOTAL_VALORES_DIFERENTES
             FROM DIF.CONFIGURATION P
             GROUP BY P.CONFIG_NODE_ID, KEY 
             HAVING COUNT(*) > 1) LOOP

      IF R.TOTAL_VALORES_DIFERENTES > 1 THEN
        SAVISOS := SAVISOS || CHR(13)||CHR(10) || 
                   '- SELECT C.*, C.ROWID ' ||
                   ' FROM DIF.CONFIGURATION C ' ||
                   ' WHERE C.CONFIG_NODE_ID = ' || R.CONFIG_NODE_ID || 
                   ' AND KEY = '''|| R.KEY || '''';
      ELSE
        
        DELETE FROM DIF.CONFIGURATION C1
        WHERE C1.CONFIG_NODE_ID = R.CONFIG_NODE_ID
        AND   C1.KEY            = R.KEY
        AND C1.ROWID            > (  SELECT MIN(ROWID) 
                                     FROM DIF.CONFIGURATION C2 
                                     WHERE C1.CONFIG_NODE_ID = C2.CONFIG_NODE_ID 
                                     AND C1.KEY = C2.KEY );
      END IF;
  END LOOP;
  
  COMMIT;
  
  IF SAVISOS IS NOT NULL THEN
    SAVISOS := 'SITUAES NAS CONFIGURAES QUE NECESSITAM DE ALTERAO MANUAL:' || SAVISOS;
    DBMS_OUTPUT.PUT_LINE(SAVISOS);
    RAISE_APPLICATION_ERROR(-20000, SAVISOS );
  END IF;
END;
/


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIGURATION'
  AND    CONSTRAINT_NAME = 'CONFIGURATION_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIGURATION ADD CONSTRAINT CONFIGURATION_UK UNIQUE (CONFIG_NODE_ID, KEY)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'CONFIG_NODE'
  AND    CONSTRAINT_NAME = 'CONFIG_NODE_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_NODE ADD CONSTRAINT CONFIG_NODE_UK UNIQUE (CONFIG_SET_ID, NODE_PATH)';
  END IF;
END;
/