/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IEventDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class EventDAOImpl
implements IEventDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Event> getEventDataSet() {
        return new HibernateDataSet(Event.class, (IHibernateDAO)this, Event.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Event transientInstance) {
        this.logger.debug((Object)"persisting Event instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Event instance) {
        this.logger.debug((Object)"attaching dirty Event instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Event instance) {
        this.logger.debug((Object)"attaching clean Event instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Event persistentInstance) {
        this.logger.debug((Object)"deleting Event instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Event merge(Event detachedInstance) {
        this.logger.debug((Object)"merging Event instance");
        Event result = (Event)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Event findById(Long id) {
        this.logger.debug((Object)("getting Event instance with id: " + id));
        Event instance = (Event)this.getSession().get(Event.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Event> findAll() {
        List<Event> instances = new ArrayList();
        this.logger.debug((Object)"getting all Event instances");
        instances = this.getSession().createCriteria(Event.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Event> findByExample(Event instance) {
        this.logger.debug((Object)"finding Event instance by example");
        List results = this.getSession().createCriteria(Event.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Event> findByFieldParcial(Event.Fields field, String value) {
        this.logger.debug((Object)("finding Event instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Event.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

