/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class IndicatorDAOImpl
implements IIndicatorDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Indicator> getIndicatorDataSet() {
        return new HibernateDataSet(Indicator.class, (IHibernateDAO)this, Indicator.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Indicator transientInstance) {
        this.logger.debug((Object)"persisting Indicator instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Indicator instance) {
        this.logger.debug((Object)"attaching dirty Indicator instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Indicator instance) {
        this.logger.debug((Object)"attaching clean Indicator instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Indicator persistentInstance) {
        this.logger.debug((Object)"deleting Indicator instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Indicator merge(Indicator detachedInstance) {
        this.logger.debug((Object)"merging Indicator instance");
        Indicator result = (Indicator)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Indicator findById(Long id) {
        this.logger.debug((Object)("getting Indicator instance with id: " + id));
        Indicator instance = (Indicator)this.getSession().get(Indicator.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Indicator> findAll() {
        List<Indicator> instances = new ArrayList();
        this.logger.debug((Object)"getting all Indicator instances");
        instances = this.getSession().createCriteria(Indicator.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Indicator> findByExample(Indicator instance) {
        this.logger.debug((Object)"finding Indicator instance by example");
        List results = this.getSession().createCriteria(Indicator.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value) {
        this.logger.debug((Object)("finding Indicator instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Indicator.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

