/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IManagerDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class ManagerDAOImpl
implements IManagerDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Manager> getManagerDataSet() {
        return new HibernateDataSet(Manager.class, (IHibernateDAO)this, Manager.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Manager transientInstance) {
        this.logger.debug((Object)"persisting Manager instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Manager instance) {
        this.logger.debug((Object)"attaching dirty Manager instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Manager instance) {
        this.logger.debug((Object)"attaching clean Manager instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Manager persistentInstance) {
        this.logger.debug((Object)"deleting Manager instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Manager merge(Manager detachedInstance) {
        this.logger.debug((Object)"merging Manager instance");
        Manager result = (Manager)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Manager findById(Long id) {
        this.logger.debug((Object)("getting Manager instance with id: " + id));
        Manager instance = (Manager)this.getSession().get(Manager.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Manager> findAll() {
        List<Manager> instances = new ArrayList();
        this.logger.debug((Object)"getting all Manager instances");
        instances = this.getSession().createCriteria(Manager.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Manager> findByExample(Manager instance) {
        this.logger.debug((Object)"finding Manager instance by example");
        List results = this.getSession().createCriteria(Manager.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Manager> findByFieldParcial(Manager.Fields field, String value) {
        this.logger.debug((Object)("finding Manager instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Manager.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

