/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IPersistentFormDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class PersistentFormDAOImpl
implements IPersistentFormDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<PersistentForm> getPersistentFormDataSet() {
        return new HibernateDataSet(PersistentForm.class, (IHibernateDAO)this, PersistentForm.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(PersistentForm transientInstance) {
        this.logger.debug((Object)"persisting PersistentForm instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(PersistentForm instance) {
        this.logger.debug((Object)"attaching dirty PersistentForm instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(PersistentForm instance) {
        this.logger.debug((Object)"attaching clean PersistentForm instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(PersistentForm persistentInstance) {
        this.logger.debug((Object)"deleting PersistentForm instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public PersistentForm merge(PersistentForm detachedInstance) {
        this.logger.debug((Object)"merging PersistentForm instance");
        PersistentForm result = (PersistentForm)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public PersistentForm findById(Long id) {
        this.logger.debug((Object)("getting PersistentForm instance with id: " + id));
        PersistentForm instance = (PersistentForm)this.getSession().get(PersistentForm.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<PersistentForm> findAll() {
        List<PersistentForm> instances = new ArrayList();
        this.logger.debug((Object)"getting all PersistentForm instances");
        instances = this.getSession().createCriteria(PersistentForm.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<PersistentForm> findByExample(PersistentForm instance) {
        this.logger.debug((Object)"finding PersistentForm instance by example");
        List results = this.getSession().createCriteria(PersistentForm.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<PersistentForm> findByFieldParcial(PersistentForm.Fields field, String value) {
        this.logger.debug((Object)("finding PersistentForm instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(PersistentForm.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

